/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.screens;

import com.google.common.collect.Lists;
import dev.amble.ait.client.models.exteriors.BedrockExteriorModel;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.screens.ConsoleScreen;
import dev.amble.ait.client.screens.interior.InteriorSettingsScreen;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.category.ClassicCategory;
import dev.amble.ait.data.schema.exterior.category.ExclusiveCategory;
import dev.amble.ait.data.schema.exterior.category.PoliceBoxCategory;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7077;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7842;

public class MonitorScreen
extends ConsoleScreen {
    private static final class_2960 TEXTURE = new class_2960("ait", "textures/gui/tardis/monitor/monitor_gui.png");
    private final List<class_4185> buttons = Lists.newArrayList();
    private ExteriorCategorySchema category;
    private ClientExteriorVariantSchema currentVariant;
    int backgroundHeight = 166;
    int backgroundWidth = 256;
    private int tickForSpin = 0;
    private final int APPLY_BUTTON_WIDTH = 53;
    private final int APPLY_BUTTON_HEIGHT = 20;
    private final int SMALL_ARROW_BUTTON_WIDTH = 20;
    private final int SMALL_ARROW_BUTTON_HEIGHT = 12;
    private final int BIG_ARROW_BUTTON_WIDTH = 20;
    private final int BIG_ARROW_BUTTON_HEIGHT = 20;
    private final int INTERIOR_SETTINGS_BUTTON_WIDTH = 20;
    private final int INTERIOR_SETTINGS_BUTTON_HEIGHT = 20;
    final int UV_BASE = 160;
    final int UV_INCREMENT = 19;

    public MonitorScreen(ClientTardis tardis, class_2338 console) {
        super((class_2561)class_2561.method_43471((String)"screen.ait.monitor"), tardis, console);
    }

    public boolean method_25421() {
        return false;
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063((class_364)button);
        this.buttons.add((class_4185)button);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.createButtons();
    }

    public ExteriorCategorySchema getCategory() {
        return this.category == null ? this.tardis().getExterior().getCategory() : this.category;
    }

    public void setCategory(ExteriorCategorySchema category) {
        this.category = category;
        if (this.currentVariant == null) {
            return;
        }
        if (this.currentVariant.parent().category() != category) {
            this.currentVariant = null;
        }
    }

    public ClientExteriorVariantSchema getCurrentVariant() {
        if (this.currentVariant == null) {
            if (!this.tardis().getExterior().getCategory().equals(this.getCategory())) {
                this.setCurrentVariant(this.getCategory().getDefaultVariant());
            } else {
                this.setCurrentVariant(this.tardis().getExterior().getVariant());
            }
        }
        return this.currentVariant;
    }

    public void setCurrentVariant(ExteriorVariantSchema var) {
        this.setCurrentVariant(ClientExteriorVariantRegistry.withParent(var));
    }

    public void setCurrentVariant(ClientExteriorVariantSchema currentVariant) {
        this.currentVariant = currentVariant;
    }

    private void createButtons() {
        this.buttons.clear();
        class_5250 applyText = class_2561.method_43471((String)"screen.ait.monitor.apply");
        this.method_37060((class_4068)new class_7842(this.field_22789 / 2 + 44, this.field_22790 / 2 + 3, 53, 20, (class_2561)applyText.method_27692(class_124.field_1067), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 44, this.field_22790 / 2 + 3, 53, 20, (class_2561)class_2561.method_43473(), button -> MonitorScreen.sendExteriorPacket(this.tardis(), this.getCategory(), this.getCurrentVariant()), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 23, this.field_22790 / 2 + 3, 20, 20, (class_2561)class_2561.method_43473(), button -> this.changeCategory(false), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 98, this.field_22790 / 2 + 3, 20, 20, (class_2561)class_2561.method_43473(), button -> this.changeCategory(true), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 23, this.field_22790 / 2 + 61, 20, 12, (class_2561)class_2561.method_43473(), button -> this.whichDirectionVariant(false), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 98, this.field_22790 / 2 + 61, 20, 12, (class_2561)class_2561.method_43473(), button -> this.whichDirectionVariant(true), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 - 13, this.field_22790 / 2 + 52, 20, 20, (class_2561)class_2561.method_43473(), button -> this.toInteriorSettingsScreen(), this.field_22793));
        this.buttons.forEach(buttons -> {
            buttons.field_22763 = true;
        });
    }

    public static void sendExteriorPacket(ClientTardis tardis, ExteriorCategorySchema category, ClientExteriorVariantSchema variant) {
        if (category != tardis.getExterior().getCategory() || variant.parent() != tardis.getExterior().getVariant()) {
            ClientTardisUtil.changeExteriorWithScreen(tardis, variant.id(), variant.parent() != tardis.getExterior().getVariant());
        }
    }

    public void toInteriorSettingsScreen() {
        if (this.tardis() == null || this.tardis().isGrowth()) {
            return;
        }
        class_310.method_1551().method_29970((class_437)new InteriorSettingsScreen(this.tardis(), this.console, this));
    }

    public void changeCategory(boolean direction) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (direction) {
            this.setCategory(this.nextCategory());
        } else {
            this.setCategory(this.previousCategory());
        }
        if (CategoryRegistry.EXCLUSIVE.equals(this.category) && !ExclusiveCategory.isUnlocked(player.method_5667()) || CategoryRegistry.CORAL_GROWTH.equals(this.category)) {
            this.changeCategory(direction);
        }
    }

    public ExteriorCategorySchema nextCategory() {
        List list = CategoryRegistry.getInstance().toList();
        int idx = list.indexOf(this.getCategory());
        idx = (idx + 1) % list.size();
        return (ExteriorCategorySchema)list.get(idx);
    }

    public ExteriorCategorySchema previousCategory() {
        List list = CategoryRegistry.getInstance().toList();
        int idx = list.indexOf(this.getCategory());
        idx = (idx - 1 + list.size()) % list.size();
        return (ExteriorCategorySchema)list.get(idx);
    }

    public void whichDirectionVariant(boolean direction) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (direction) {
            this.setCurrentVariant(this.nextVariant());
        } else {
            this.setCurrentVariant(this.previousVariant());
        }
    }

    public ExteriorVariantSchema nextVariant() {
        List list = ExteriorVariantRegistry.withParent(this.getCurrentVariant().parent().category()).stream().toList();
        int idx = list.indexOf(this.getCurrentVariant().parent());
        idx = (idx + 1) % list.size();
        return (ExteriorVariantSchema)list.get(idx);
    }

    public ExteriorVariantSchema previousVariant() {
        List list = ExteriorVariantRegistry.withParent(this.getCurrentVariant().parent().category()).stream().toList();
        int idx = list.indexOf(this.getCurrentVariant().parent());
        idx = (idx - 1 + list.size()) % list.size();
        return (ExteriorVariantSchema)list.get(idx);
    }

    int calculateUvOffsetForRange(int progress) {
        int rangeProgress = progress % 19;
        return rangeProgress / 5 * 19;
    }

    protected void drawBackground(class_332 context) {
        if (this.tardis() == null) {
            return;
        }
        int i = (this.field_22789 - this.backgroundWidth) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        context.method_25302(TEXTURE, i, j, 0, 0, this.backgroundWidth, this.backgroundHeight);
        if (!this.buttons.get(0).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(0).method_46426(), this.buttons.get(0).method_46427(), 40, 166, 53, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(0).method_46426(), this.buttons.get(0).method_46427(), 40, 186, 53, 20);
        }
        if (!this.buttons.get(1).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(1).method_46426(), this.buttons.get(1).method_46427(), 0, 166, 20, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(1).method_46426(), this.buttons.get(1).method_46427(), 0, 186, 20, 20);
        }
        if (!this.buttons.get(2).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(2).method_46426(), this.buttons.get(2).method_46427(), 20, 166, 20, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(2).method_46426(), this.buttons.get(2).method_46427(), 20, 186, 20, 20);
        }
        if (!this.buttons.get(3).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(3).method_46426(), this.buttons.get(3).method_46427(), 93, 166, 20, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(3).method_46426(), this.buttons.get(3).method_46427(), 93, 178, 20, 12);
        }
        if (!this.buttons.get(4).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(4).method_46426(), this.buttons.get(4).method_46427(), 113, 166, 20, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(4).method_46426(), this.buttons.get(4).method_46427(), 113, 178, 20, 12);
        }
        if (!this.buttons.get(5).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(5).method_46426(), this.buttons.get(5).method_46427(), 186, 166, 20, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(5).method_46426(), this.buttons.get(5).method_46427(), 186, 186, 20, 20);
        }
        context.method_25302(TEXTURE, i + 16, j + 144, 0, this.tardis().getFuel() > 12500.0 ? 225 : 234, (int)(85.0 * this.tardis().getFuel() / 50000.0), 9);
        int progress = this.tardis().travel().getDurationAsPercentage();
        for (int index = 0; index < 5; ++index) {
            int rangeStart = index * 19;
            int rangeEnd = (index + 1) * 19;
            int uvOffset = progress >= rangeStart && progress <= rangeEnd ? this.calculateUvOffsetForRange(progress) : (progress >= rangeEnd ? 76 : 160);
            context.method_25302(TEXTURE, i + 11 + index * 19, j + 113, this.tardis().travel().getState() == TravelHandlerBase.State.FLIGHT ? (progress >= 100 ? 76 : uvOffset) : 160, 206, 19, 19);
        }
    }

    protected void drawTardisExterior(class_332 context, int x, int y, float scale) {
        ++this.tickForSpin;
        ClientTardis tardis = this.tardis();
        if (tardis == null) {
            return;
        }
        class_4587 stack = context.method_51448();
        int centerWidth = this.field_22789 / 2;
        int centerHeight = this.field_22790 / 2;
        ExteriorCategorySchema category = this.getCategory();
        ClientExteriorVariantSchema variant = this.getCurrentVariant();
        if (category == null || variant == null) {
            return;
        }
        boolean isPoliceBox = category.equals(CategoryRegistry.getInstance().get(PoliceBoxCategory.REFERENCE)) || category.equals(CategoryRegistry.getInstance().get(ClassicCategory.REFERENCE));
        boolean isHorriblyUnscaled = variant.equals(ClientExteriorVariantRegistry.DOOM);
        boolean isExtUnlocked = tardis.isUnlocked(variant.parent());
        boolean hasPower = tardis.fuel().hasPower();
        boolean alarms = tardis.alarm().isEnabled();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 500.0f);
        context.method_27534(this.field_22793, category.text(), centerWidth + 70, centerHeight - 68, 0x55FFFF);
        List<ExteriorVariantSchema> list = ExteriorVariantRegistry.withParent(category);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(list.indexOf(variant.parent()) + 1 + "/" + list.size())).method_27692(class_124.field_1067), centerWidth + 70, centerHeight + 64, 0xFFFFFF);
        context.method_27534(this.field_22793, variant.parent().text(), centerWidth + 70, centerHeight + 44, 0x55FFFF);
        context.method_25300(this.field_22793, variant.parent().id().method_12836().toUpperCase(), centerWidth + 70, centerHeight + 34, 0x55FFFF);
        stack.method_22909();
        ExteriorModel model = variant.model();
        stack.method_22903();
        stack.method_46416((float)x, isPoliceBox || isHorriblyUnscaled ? (float)(y + 11) : (float)y, 100.0f);
        if (isPoliceBox) {
            stack.method_22905(-12.0f, 12.0f, 12.0f);
        } else if (isHorriblyUnscaled) {
            stack.method_22905(-12.0f, 12.0f, 12.0f);
        } else {
            stack.method_22905(-scale, scale, scale);
        }
        if (variant.model() instanceof BedrockExteriorModel) {
            stack.method_46416(0.0f, 1.25f, 0.0f);
        }
        stack.method_22907(class_7833.field_40715.rotationDegrees((float)this.tickForSpin / 1200.0f * 360.0f));
        class_2960 texture = variant.texture();
        class_2960 emissive = variant.emission();
        float base = isExtUnlocked ? 1.0f : 0.1f;
        float tinted = alarms && isExtUnlocked ? 0.3f : base;
        model.method_2828(stack, context.method_51450().getBuffer(AITRenderLayers.method_23689((class_2960)texture)), 0xF000F0, class_4608.field_21444, base, base, base, 1.0f);
        if (hasPower && emissive != null && !emissive.equals((Object)DatapackConsole.EMPTY)) {
            model.method_2828(stack, context.method_51450().getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(emissive, true)), 0xF000F0, class_4608.field_21444, base, base, base, 1.0f);
        }
        stack.method_22909();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 550.0f);
        context.method_25300(this.field_22793, isExtUnlocked ? "" : "\ud83d\udd12", x, y, 0xFFFFFF);
        class_4597.class_4598 vertex = context.method_51450();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 50.0f);
        context.method_25300(this.field_22793, isExtUnlocked ? "" : "\ud83d\udd12", x, y, 0xFFFFFF);
        stack.method_22909();
        stack.method_22909();
    }

    public void method_25420(class_332 context) {
        super.method_25420(context);
    }

    protected void drawInformationText(class_332 context) {
        if (this.tardis() == null) {
            return;
        }
        TravelHandler travel = this.tardis().travel();
        CachedDirectedGlobalPos abpd = travel.getState() == TravelHandlerBase.State.FLIGHT ? travel.getProgress() : travel.position();
        CachedDirectedGlobalPos dabpd = travel.destination();
        if (abpd.getDimension() == null) {
            return;
        }
        class_2338 abpdPos = abpd.getPos();
        String positionText = abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        class_2561 dimensionText = WorldUtil.worldText((class_5321<class_1937>)abpd.getDimension());
        class_2338 dabpdPos = dabpd.getPos();
        String destinationText = dabpdPos.method_10263() + ", " + dabpdPos.method_10264() + ", " + dabpdPos.method_10260();
        class_2561 dDimensionText = WorldUtil.worldText((class_5321<class_1937>)dabpd.getDimension(), false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)positionText), this.field_22789 / 2 - 119, this.field_22790 / 2 - 48, 0xFFFFFF, true);
        context.method_51439(this.field_22793, dimensionText, this.field_22789 / 2 - 119, this.field_22790 / 2 - 38, 0xFFFFFF, true);
        context.method_51430(this.field_22793, WorldUtil.rot2Text(abpd.getRotation()).method_30937(), this.field_22789 / 2 - 119, this.field_22790 / 2 - 28, 0xFFFFFF, true);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)destinationText), this.field_22789 / 2 - 119, this.field_22790 / 2 - 10, 0xFFFFFF, true);
        context.method_51439(this.field_22793, dDimensionText, this.field_22789 / 2 - 119, this.field_22790 / 2, 0xFFFFFF, true);
        context.method_51430(this.field_22793, WorldUtil.rot2Text(dabpd.getRotation()).method_30937(), this.field_22789 / 2 - 119, this.field_22790 / 2 + 10, 0xFFFFFF, true);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i = (this.field_22790 - this.backgroundHeight) / 2;
        int j = (this.field_22789 - this.backgroundWidth) / 2;
        class_4587 stack = context.method_51448();
        this.drawTardisExterior(context, this.field_22789 / 2 + 70, this.field_22790 / 2 - 30, 19.0f);
        this.drawBackground(context);
        this.drawInformationText(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }
}

