/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.client.screens.ConsoleScreen;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.ait.registry.impl.SonicRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7077;

public class SonicSettingsScreen
extends ConsoleScreen {
    private static final class_2960 BACKGROUND = new class_2960("ait", "textures/gui/tardis/monitor/sonic_selection.png");
    private final List<class_4185> buttons = Lists.newArrayList();
    int bgHeight = 130;
    int bgWidth = 216;
    int left;
    int top;
    int choicesCount = 0;
    private final class_437 parent;
    private int selectedSonic;
    private final int APPLY_BAR_BUTTON_WIDTH = 53;
    private final int APPLY_BAR_BUTTON_HEIGHT = 12;
    private final int SMALL_ARROW_BUTTON_WIDTH = 20;
    private final int SMALL_ARROW_BUTTON_HEIGHT = 12;
    private final class_2338 console;

    public SonicSettingsScreen(ClientTardis tardis, class_2338 console, class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.ait.sonicsettings.title"), tardis, console);
        this.console = console;
        this.parent = parent;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(this.console);
        if (!(class_25862 instanceof ConsoleBlockEntity)) {
            return;
        }
        ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)class_25862;
        SonicSchema schema = SonicItem.schema(consoleBlockEntity.getSonicScrewdriver());
        this.selectedSonic = SonicRegistry.getInstance().toList().indexOf(schema);
        this.top = (this.field_22790 - this.bgHeight) / 2;
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.createButtons();
        super.method_25426();
    }

    private void createButtons() {
        this.choicesCount = 0;
        this.buttons.clear();
        this.addButton(new AITPressableTextWidget((int)((float)this.left + (float)this.bgWidth * 0.139f), (int)((float)this.top + (float)this.bgHeight * 0.839f), 53, 12, (class_2561)class_2561.method_43473(), button -> this.sendSonicChangePacket(), this.field_22793));
        class_5250 back = class_2561.method_43471((String)"screen.ait.sonicsettings.back");
        this.addButton(new class_7077(this.field_22789 / 2 - 102, this.field_22790 / 2 - 59, this.field_22793.method_27525((class_5348)back), 10, (class_2561)back, button -> this.backToInteriorSettings(), this.field_22793));
        this.addButton(new AITPressableTextWidget((int)((float)this.left + (float)this.bgWidth * 0.042f), (int)((float)this.top + (float)this.bgHeight * 0.839f), 20, 12, (class_2561)class_2561.method_43473(), button -> this.getLastSelectedSonic(), this.field_22793));
        this.addButton(new AITPressableTextWidget((int)((float)this.left + (float)this.bgWidth * 0.389f), (int)((float)this.top + (float)this.bgHeight * 0.839f), 20, 12, (class_2561)class_2561.method_43473(), button -> this.getNextSelectedSonic(), this.field_22793));
    }

    public void backToInteriorSettings() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void sendSonicChangePacket() {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(this.console);
        if (!(class_25862 instanceof ConsoleBlockEntity)) {
            return;
        }
        ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)class_25862;
        if (consoleBlockEntity.getSonicScrewdriver() == null) {
            return;
        }
        SonicSchema schema = (SonicSchema)SonicRegistry.getInstance().toList().get(this.selectedSonic);
        if (!this.tardis().isUnlocked(schema)) {
            return;
        }
        SonicItem.setSchema(consoleBlockEntity.getSonicScrewdriver(), schema);
        ClientTardisUtil.changeSonicWithScreen(this.tardis().getUuid(), schema, this.console);
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063((class_364)button);
        button.field_22763 = true;
        this.buttons.add((class_4185)button);
    }

    private void createTextButton(class_2561 text, class_4185.class_4241 onPress) {
        this.addButton(new class_7077((int)((float)this.left + (float)this.bgWidth * 0.06f), (int)((float)this.top + (float)this.bgHeight * (0.1f * (float)(this.choicesCount + 1))), this.field_22793.method_27525((class_5348)text), 10, text, onPress, this.field_22793));
        ++this.choicesCount;
    }

    public void method_25420(class_332 context) {
        super.method_25420(context);
    }

    protected void drawSonicScrewdriver(class_332 context, int x, int y, float scale) {
        if (this.tardis() == null) {
            return;
        }
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(this.console);
        if (!(class_25862 instanceof ConsoleBlockEntity)) {
            return;
        }
        ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)class_25862;
        if (consoleBlockEntity.getSonicScrewdriver() == null) {
            return;
        }
        class_1799 sonic = consoleBlockEntity.getSonicScrewdriver();
        if (sonic.method_7960()) {
            return;
        }
        class_2487 nbt = sonic.method_7948();
        if (this.tardis() != null) {
            class_4587 stack = context.method_51448();
            class_1799 sonicCopy = sonic.method_7972();
            SonicSchema schema = (SonicSchema)SonicRegistry.getInstance().toList().get(this.selectedSonic);
            SonicItem.setSchema(sonicCopy, schema);
            stack.method_22903();
            stack.method_46416(50.0f, 50.0f, 1000.0f);
            context.method_25300(this.field_22793, this.tardis().isUnlocked(schema) ? "" : "\ud83d\udd12", x, y, 0xFFFFFF);
            stack.method_22909();
            stack.method_22903();
            SonicSchema.Rendering rendering = schema.rendering();
            SonicSchema.Rendering.Offset positionOffset = rendering.getPositionOffset();
            SonicSchema.Rendering.Offset scaleOffset = rendering.getScaleOffset();
            stack.method_46416((float)x + positionOffset.x(), (float)y + positionOffset.y(), positionOffset.z());
            stack.method_22905(scale + scaleOffset.x(), scale + scaleOffset.y(), scale + scaleOffset.z());
            boolean isSonicUnlocked = this.tardis().isUnlocked(schema);
            float base = isSonicUnlocked ? 1.0f : 0.1f;
            RenderSystem.setShaderColor((float)base, (float)base, (float)base, (float)1.0f);
            class_308.method_24210();
            context.method_51427(sonicCopy, 0, 0);
            class_308.method_24211();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.method_22909();
            stack.method_22903();
            stack.method_46416(10.0f, 0.0f, 500.0f);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.ait.sonic_casing"), x + 140, y + 10, 0xFFFFFF);
            context.method_25300(this.field_22793, SonicItem.schema(sonicCopy).name(), x + 140, y + 20, 65535);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.ait.current_au"), x + 140, y + 40, 0xFFFFFF);
            context.method_25300(this.field_22793, nbt.method_10574("fuel") + " AU", x + 140, y + 50, 65535);
            UUID tardis = LinkableItem.getTardisIdStatic(sonicCopy);
            if (tardis != null) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.ait.linked_tardis"), x + 140, y + 70, 0xFFFFFF);
                context.method_25300(this.field_22793, tardis.toString().substring(0, 8), x + 140, y + 80, 65535);
            }
            stack.method_22909();
        }
    }

    public void getNextSelectedSonic() {
        this.selectedSonic = (this.selectedSonic + 1) % SonicRegistry.getInstance().size();
    }

    public void getLastSelectedSonic() {
        this.selectedSonic = (this.selectedSonic - 1 + SonicRegistry.getInstance().size()) % SonicRegistry.getInstance().size();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackground(context);
        this.drawSonicScrewdriver(context, this.field_22789 / 2 - 100, this.field_22790 / 2 - 45, 6.0f);
        if (!this.buttons.get(0).method_49606()) {
            context.method_25302(BACKGROUND, this.left + 30, this.top + 109, 40, 130, 53, 12);
        } else {
            context.method_25302(BACKGROUND, this.left + 30, this.top + 109, 40, 142, 53, 12);
        }
        if (!this.buttons.get(2).method_49606()) {
            context.method_25302(BACKGROUND, this.left + 9, this.top + 109, 0, 130, 20, 12);
        } else {
            context.method_25302(BACKGROUND, this.left + 9, this.top + 109, 0, 142, 20, 12);
        }
        if (!this.buttons.get(3).method_49606()) {
            context.method_25302(BACKGROUND, this.left + 84, this.top + 109, 20, 130, 20, 12);
        } else {
            context.method_25302(BACKGROUND, this.left + 84, this.top + 109, 20, 142, 20, 12);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(BACKGROUND, this.left, this.top, 0, 0, this.bgWidth, this.bgHeight);
        context.method_25302(BACKGROUND, this.left + 9, this.top + 25, 0, 154, 95, 84);
    }

    public static class AITPressableTextWidget
    extends class_4185 {
        private final class_327 textRenderer;
        private final class_2561 text;

        public AITPressableTextWidget(int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress, class_327 textRenderer) {
            super(x, y, width, height, text, onPress, field_40754);
            this.textRenderer = textRenderer;
            this.text = text;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2561 text = this.text;
            context.method_27535(this.textRenderer, text, this.method_46426(), this.method_46427(), 0xFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }
    }
}

