/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.screens;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.screens.ConsoleScreen;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import dev.amble.ait.core.tardis.handler.permissions.PermissionHandler;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.properties.bool.BoolValue;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7077;

public class TardisSecurityScreen
extends ConsoleScreen {
    private static final class_2960 TEXTURE = new class_2960("ait", "textures/gui/tardis/monitor/security_menu.png");
    int bgHeight = 138;
    int bgWidth = 216;
    int left;
    int top;
    int choicesCount = 0;
    private final class_437 parent;
    private class_342 landingCodeInput;

    public TardisSecurityScreen(ClientTardis tardis, class_2338 console, class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.ait.security.title"), tardis, console);
        this.parent = parent;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        this.top = (this.field_22790 - this.bgHeight) / 2;
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.createButtons();
        super.method_25426();
    }

    @Override
    public boolean canCloseWithKey() {
        return !this.landingCodeInput.method_20315();
    }

    private void createButtons() {
        this.choicesCount = 0;
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.interiorsettings.back"), button -> this.backToExteriorChangeScreen());
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.security.leave_behind"), button -> this.toggleLeaveBehind());
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.security.hostile_alarms"), button -> this.toggleHostileAlarms());
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.security.minimum_loyalty"), button -> this.changeMinimumLoyalty());
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.security.receive_distress_calls"), button -> this.receiveDistressCalls());
        int n = (int)((float)this.left + (float)this.bgWidth * 0.06f);
        Objects.requireNonNull(this.field_22793);
        this.landingCodeInput = new class_342(this.field_22793, n, this.top + 85, 120, 9 + 4, (class_2561)class_2561.method_43471((String)"message.ait.landing_code"));
        this.addButton(new class_7077(this.field_22789 / 2 + 40, this.field_22790 / 2 + 18, this.field_22793.method_1727("\u2713"), 20, (class_2561)class_2561.method_43470((String)"\u2713").method_27692(class_124.field_1067), button -> this.updateLandingCode(), this.field_22793));
        this.landingCodeInput.method_1880(50);
        this.landingCodeInput.method_1858(true);
        this.landingCodeInput.method_1862(true);
        if (this.tardis().landingPad().code().get().isBlank()) {
            this.landingCodeInput.method_47404((class_2561)class_2561.method_43471((String)"message.ait.enter_landing_code"));
        } else {
            this.landingCodeInput.method_1852(this.tardis().landingPad().code().get());
        }
        this.method_25429((class_364)this.landingCodeInput);
    }

    private void receiveDistressCalls() {
        BoolValue receiveCalls;
        receiveCalls.set((Boolean)(receiveCalls = ((StatsHandler)this.tardis().handler(TardisComponent.Id.STATS)).receiveCalls()).get() == false);
    }

    private void toggleLeaveBehind() {
        this.tardis().travel().leaveBehind().flatMap(value -> value == false);
    }

    private void changeMinimumLoyalty() {
        ClientTardis tardis = this.tardis();
        PermissionHandler.p19Loyalty(tardis, TardisSecurityScreen.getMinimumLoyalty(tardis).next());
    }

    private static Loyalty.Type getMinimumLoyalty(ClientTardis tardis) {
        return ((PermissionHandler)tardis.handler(TardisComponent.Id.PERMISSIONS)).p19Loyalty().get();
    }

    private void toggleHostileAlarms() {
        this.tardis().alarm().hostilePresence().flatMap(value -> value == false);
    }

    private void updateLandingCode() {
        String input = this.landingCodeInput.method_1882();
        this.tardis().landingPad().code().set(input);
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063((class_364)button);
        button.field_22763 = true;
    }

    private void createTextButton(class_2561 text, class_4185.class_4241 onPress) {
        this.addButton(new class_7077((int)((float)this.left + (float)this.bgWidth * 0.06f), (int)((float)this.top + (float)this.bgHeight * (0.1f * (float)(this.choicesCount + 1))), this.field_22793.method_27525((class_5348)text), 10, text, onPress, this.field_22793));
        ++this.choicesCount;
    }

    public void backToExteriorChangeScreen() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackground(context);
        ClientTardis tardis = this.tardis();
        class_5250 onText = class_2561.method_43471((String)"screen.ait.monitor.on");
        class_5250 offText = class_2561.method_43471((String)"screen.ait.monitor.off");
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43473().method_27693(": ").method_10852((class_2561)((Boolean)tardis.travel().leaveBehind().get() != false ? onText : offText)), (int)((float)this.left + (float)this.bgWidth * 0.46f), (int)((float)this.top + (float)this.bgHeight * 0.2f), 16753920, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43473().method_27693(": ").method_10852((class_2561)((Boolean)tardis.alarm().hostilePresence().get() != false ? onText : offText)), (int)((float)this.left + (float)this.bgWidth * 0.48f), (int)((float)this.top + (float)this.bgHeight * 0.3f), 16753920, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)": ").method_10852((class_2561)TardisSecurityScreen.getMinimumLoyalty(tardis).text()), (int)((float)this.left + (float)this.bgWidth * 0.51f), (int)((float)this.top + (float)this.bgHeight * 0.4f), 16753920, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"message.ait.date_created"), (int)((float)this.left + (float)this.bgWidth * 0.06f), (int)((double)this.top + (double)this.bgHeight * 0.7500000111758709), 11389687, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)tardis.stats().getCreationString()), (int)((float)this.left + (float)this.bgWidth * 0.06f), (int)((double)this.top + (double)this.bgHeight * 0.850000012665987), 11389687, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43473().method_27693(": ").method_10852((class_2561)((Boolean)((StatsHandler)this.tardis().handler(TardisComponent.Id.STATS)).receiveCalls().get() != false ? onText : offText)), (int)((float)this.left + (float)this.bgWidth * 0.7f), (int)((float)this.top + (float)this.bgHeight * 0.5f), 16753920, false);
        this.landingCodeInput.method_25394(context, mouseX, mouseY, delta);
        this.landingCodeInput.method_1868(this.landingCodeInput.method_25367() || !this.landingCodeInput.method_1882().isBlank() ? 0xFFFFFF : 0x545454);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(TEXTURE, this.left, this.top, 0, 0, this.bgWidth, this.bgHeight);
    }
}

