/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.screens.interior;

import com.google.common.collect.Lists;
import dev.amble.ait.api.tardis.TardisClientEvents;
import dev.amble.ait.client.screens.ConsoleScreen;
import dev.amble.ait.client.screens.SonicSettingsScreen;
import dev.amble.ait.client.screens.TardisSecurityScreen;
import dev.amble.ait.client.screens.widget.SwitcherManager;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.handler.InteriorChangingHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.registry.impl.DesktopRegistry;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7077;
import net.minecraft.class_7842;

@Environment(value=EnvType.CLIENT)
public class InteriorSettingsScreen
extends ConsoleScreen {
    private static final class_2960 BACKGROUND = new class_2960("ait", "textures/gui/tardis/monitor/interior_settings.png");
    private static final class_2960 TEXTURE = new class_2960("ait", "textures/gui/tardis/monitor/interior_settings.png");
    private static final class_2960 MISSING_PREVIEW = new class_2960("ait", "textures/gui/tardis/monitor/presets/missing_preview.png");
    private final List<class_4185> buttons = Lists.newArrayList();
    int bgHeight = 166;
    int bgWidth = 256;
    int left;
    int top;
    private int tickForSpin = 0;
    public int choicesCount = 0;
    private final class_437 parent;
    private TardisDesktopSchema selectedDesktop;
    private SwitcherManager.ModeManager modeManager;
    private final int APPLY_BUTTON_WIDTH = 53;
    private final int APPLY_BUTTON_HEIGHT = 20;
    private final int APPLY_BAR_BUTTON_WIDTH = 53;
    private final int APPLY_BAR_BUTTON_HEIGHT = 12;
    private final int SMALL_ARROW_BUTTON_WIDTH = 20;
    private final int SMALL_ARROW_BUTTON_HEIGHT = 12;
    private final int BIG_ARROW_BUTTON_WIDTH = 20;
    private final int BIG_ARROW_BUTTON_HEIGHT = 20;
    private final int MAIN_SETTINGS_BUTTON_WIDTH = 20;
    private final int MAIN_SETTINGS_BUTTON_HEIGHT = 20;
    private class_2338 console;
    final int UV_BASE = 160;
    final int UV_INCREMENT = 19;

    public InteriorSettingsScreen(ClientTardis tardis, class_2338 console, class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.ait.interiorsettings.title"), tardis, console);
        this.parent = parent;
        this.console = console;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        this.modeManager = new SwitcherManager.ModeManager(this.tardis());
        this.selectedDesktop = this.tardis().getDesktop().getSchema();
        if (this.selectedDesktop == null) {
            this.nextDesktop();
        }
        this.top = (this.field_22790 - this.bgHeight) / 2;
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.createButtons();
        super.method_25426();
    }

    private void sendCachePacket() {
        if (this.console == null) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(this.tardis().getUuid());
        buf.method_10807(this.console);
        ClientPlayNetworking.send((class_2960)TardisDesktop.CACHE_CONSOLE, (class_2540)buf);
        this.method_25419();
    }

    private void createCompatButtons() {
    }

    private void createButtons() {
        ConsoleBlockEntity consoleBlock;
        class_2586 class_25862;
        this.choicesCount = 0;
        this.buttons.clear();
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.interiorsettings.cacheconsole").method_27692(this.console != null ? class_124.field_1068 : class_124.field_1080), button -> this.sendCachePacket());
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.security.button"), button -> this.toSecurityScreen());
        boolean showSonicButton = this.console != null && (class_25862 = class_310.method_1551().field_1687.method_8321(this.console)) instanceof ConsoleBlockEntity && (consoleBlock = (ConsoleBlockEntity)class_25862).getSonicScrewdriver() != null && !consoleBlock.getSonicScrewdriver().method_7960();
        this.createTextButton((class_2561)class_2561.method_43471((String)"screen.ait.sonic.button").method_27692(showSonicButton ? class_124.field_1068 : class_124.field_1080), button -> {
            if (showSonicButton) {
                this.toSonicScreen();
            }
        });
        this.createCompatButtons();
        ((TardisClientEvents.SettingsSetup)TardisClientEvents.SETTINGS_SETUP.invoker()).onSetup(this);
        this.addButton(new class_7077(this.field_22789 / 2 + 23, this.field_22790 / 2 + 61, 20, 12, (class_2561)class_2561.method_43473(), button -> ((SwitcherManager)this.modeManager.get()).previous(), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 98, this.field_22790 / 2 + 61, 20, 12, (class_2561)class_2561.method_43473(), button -> ((SwitcherManager)this.modeManager.get()).next(), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 44, this.field_22790 / 2 + 61, 53, 12, (class_2561)class_2561.method_43473(), button -> ((SwitcherManager)this.modeManager.get()).sync(this.tardis()), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 23, this.field_22790 / 2 + 3, 20, 20, (class_2561)class_2561.method_43473(), button -> this.previousDesktop(), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 98, this.field_22790 / 2 + 3, 20, 20, (class_2561)class_2561.method_43473(), button -> this.nextDesktop(), this.field_22793));
        class_5250 applyInteriorText = class_2561.method_43471((String)"screen.ait.monitor.apply");
        this.method_37060((class_4068)new class_7842(this.field_22789 / 2 + 44, this.field_22790 / 2 + 3, 53, 20, (class_2561)applyInteriorText.method_27692(class_124.field_1067), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 44, this.field_22790 / 2 + 3, 53, 20, (class_2561)class_2561.method_43473(), button -> this.applyDesktop(), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 - 13, this.field_22790 / 2 + 52, 20, 20, (class_2561)class_2561.method_43473(), button -> this.backToExteriorChangeScreen(), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 77, this.field_22790 / 2 + 30, 20, 12, (class_2561)class_2561.method_43473(), button -> this.modeManager.previous(), this.field_22793));
        this.addButton(new class_7077(this.field_22789 / 2 + 98, this.field_22790 / 2 + 30, 20, 12, (class_2561)class_2561.method_43473(), button -> this.modeManager.next(), this.field_22793));
    }

    private void toSonicScreen() {
        class_310.method_1551().method_1507((class_437)new SonicSettingsScreen(this.tardis(), this.console, this));
    }

    public <T extends class_339> void addButton(T button) {
        this.method_37063((class_364)button);
        button.field_22763 = true;
        this.buttons.add((class_4185)button);
    }

    public class_7077 createTextButton(class_2561 text, class_4185.class_4241 onPress) {
        return this.createAnyButton(text, class_7077::new, onPress);
    }

    public <T extends class_4185> T initAnyButton(class_2561 text, ButtonCreator<T> creator, class_4185.class_4241 onPress) {
        return creator.create((int)((float)this.left + (float)this.bgWidth * 0.06f), (int)((float)this.top + (float)this.bgHeight * (0.1f * (float)(this.choicesCount + 1))), this.field_22793.method_27525((class_5348)text), 10, text, onPress, this.field_22793);
    }

    public <T extends class_4185> T initAnyDynamicButton(Function<T, class_2561> text, DynamicButtonCreator<T> creator, class_4185.class_4241 onPress) {
        return creator.create((int)((float)this.left + (float)this.bgWidth * 0.06f), (int)((float)this.top + (float)this.bgHeight * (0.1f * (float)(this.choicesCount + 1))), this.field_22793.method_27525((class_5348)class_2561.method_43473()), 10, text, onPress, this.field_22793);
    }

    public <T extends class_4185> T createAnyButton(class_2561 text, ButtonCreator<T> creator, class_4185.class_4241 onPress) {
        T result = this.initAnyButton(text, creator, onPress);
        this.addButton(result);
        ++this.choicesCount;
        return result;
    }

    public <T extends class_4185> T createAnyDynamicButton(Function<T, class_2561> text, DynamicButtonCreator<T> creator, class_4185.class_4241 onPress) {
        T result = this.initAnyDynamicButton(text, creator, onPress);
        this.addButton(result);
        ++this.choicesCount;
        return result;
    }

    public void backToExteriorChangeScreen() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void toSecurityScreen() {
        class_310.method_1551().method_1507((class_437)new TardisSecurityScreen(this.tardis(), this.console, this));
    }

    int calculateUvOffsetForRange(int progress) {
        int rangeProgress = progress % 19;
        return rangeProgress / 5 * 19;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int buttonIndex;
        int i = (this.field_22789 - this.bgWidth) / 2;
        int j = (this.field_22790 - this.bgHeight) / 2;
        this.renderDesktop(context);
        this.drawBackground(context);
        context.method_51448().method_22903();
        int x = this.left + 79;
        int y = this.top + 59;
        context.method_51448().method_46416(0.0f, 0.0f, 0.0f);
        context.method_51448().method_22909();
        int n = buttonIndex = DependencyChecker.hasGravity() ? 4 : 3;
        if (!this.buttons.get(buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 166, 20, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 178, 20, 12);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 166, 20, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 178, 20, 12);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 133, 166, 53, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 133, 178, 53, 12);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 0, 166, 20, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 0, 186, 20, 20);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 20, 166, 20, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 20, 186, 20, 20);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 40, 166, 53, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 40, 186, 53, 20);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 186, 166, 20, 20);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 186, 186, 20, 20);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 166, 20, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 178, 20, 12);
        }
        if (!this.buttons.get(++buttonIndex).method_49606()) {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 166, 20, 12);
        } else {
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 178, 20, 12);
        }
        if (this.tardis() == null) {
            return;
        }
        context.method_25302(TEXTURE, i + 16, j + 144, 0, this.tardis().getFuel() > 12500.0 ? 225 : 234, (int)(85.0 * this.tardis().getFuel() / 50000.0), 9);
        int progress = this.tardis().travel().getDurationAsPercentage();
        for (int index = 0; index < 5; ++index) {
            int rangeStart = index * 19;
            int rangeEnd = (index + 1) * 19;
            int uvOffset = progress >= rangeStart && progress <= rangeEnd ? this.calculateUvOffsetForRange(progress) : (progress >= rangeEnd ? 76 : 160);
            context.method_25302(TEXTURE, i + 11 + index * 19, j + 113, this.tardis().travel().getState() == TravelHandlerBase.State.FLIGHT ? (progress >= 100 ? 76 : uvOffset) : 160, 206, 19, 19);
        }
        this.renderCurrentMode(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(BACKGROUND, this.left, this.top, 0, 0, this.bgWidth, this.bgHeight);
    }

    private void renderDesktop(class_332 context) {
        if (this.selectedDesktop == null) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 15.0f);
        context.method_25300(this.field_22793, this.selectedDesktop.name(), (int)((float)this.left + (float)this.bgWidth * 0.77f), (int)((float)this.top + (float)this.bgHeight * 0.08f), 0xFFFFFF);
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_25293(InteriorSettingsScreen.doesTextureExist(this.selectedDesktop.previewTexture().texture()) ? this.selectedDesktop.previewTexture().texture() : MISSING_PREVIEW, this.left + 151, this.top + 10, 95, 95, 0.0f, 0.0f, this.selectedDesktop.previewTexture().width * 2, this.selectedDesktop.previewTexture().height * 2, this.selectedDesktop.previewTexture().width * 2, this.selectedDesktop.previewTexture().height * 2);
        context.method_51448().method_22909();
    }

    private void renderCurrentMode(class_332 context) {
        Object current = ((SwitcherManager)this.modeManager.get()).get();
        class_5250 modeText = class_2561.method_43470((String)((SwitcherManager)this.modeManager.get()).name().toUpperCase());
        context.method_51439(this.field_22793, (class_2561)modeText, this.field_22789 / 2 + 50 - this.field_22793.method_27525((class_5348)modeText) / 2, this.field_22790 / 2 + 32, 0xFFFFFF, true);
        class_5250 currentText = class_2561.method_43470((String)current.name().toUpperCase());
        context.method_51439(this.field_22793, (class_2561)currentText, (int)((float)this.left + (float)this.bgWidth * 0.78f) - this.field_22793.method_27525((class_5348)currentText) / 2, (int)((float)this.top + (float)this.bgHeight * 0.792f), 0xFFFFFF, true);
    }

    private void applyDesktop() {
        if (this.selectedDesktop == null) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(this.tardis().getUuid());
        buf.method_10812(this.selectedDesktop.id());
        ClientPlayNetworking.send((class_2960)InteriorChangingHandler.CHANGE_DESKTOP, (class_2540)buf);
        class_310.method_1551().method_1507(null);
    }

    private static TardisDesktopSchema nextDesktop(TardisDesktopSchema current) {
        List list = DesktopRegistry.getInstance().toList();
        int idx = current == null ? -1 : list.indexOf(current);
        idx = (idx + 1) % list.size();
        return (TardisDesktopSchema)list.get(idx);
    }

    private void nextDesktop() {
        this.selectedDesktop = InteriorSettingsScreen.nextDesktop(this.selectedDesktop);
        if (!this.isCurrentUnlocked() || this.selectedDesktop == DesktopRegistry.DEFAULT_CAVE) {
            this.nextDesktop();
        }
    }

    private static TardisDesktopSchema previousDesktop(TardisDesktopSchema current) {
        List list = DesktopRegistry.getInstance().toList();
        int idx = current == null ? -1 : list.indexOf(current);
        idx = (idx - 1 + list.size()) % list.size();
        return (TardisDesktopSchema)list.get(idx);
    }

    private void previousDesktop() {
        this.selectedDesktop = InteriorSettingsScreen.previousDesktop(this.selectedDesktop);
        if (!this.isCurrentUnlocked() || this.selectedDesktop == DesktopRegistry.DEFAULT_CAVE) {
            this.previousDesktop();
        }
    }

    public static boolean doesTextureExist(class_2960 id) {
        return class_310.method_1551().method_1478().method_14486(id).isPresent();
    }

    private boolean isCurrentUnlocked() {
        return this.tardis().isUnlocked(this.selectedDesktop);
    }

    @FunctionalInterface
    public static interface ButtonCreator<T extends class_4185> {
        public T create(int var1, int var2, int var3, int var4, class_2561 var5, class_4185.class_4241 var6, class_327 var7);
    }

    @FunctionalInterface
    public static interface DynamicButtonCreator<T extends class_4185> {
        public T create(int var1, int var2, int var3, int var4, Function<T, class_2561> var5, class_4185.class_4241 var6, class_327 var7);
    }
}

