/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.sounds;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.sounds.PlayerFollowingLoopingSound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SoundHandler {
    private static final List<class_1113> EMPTY = List.of();
    protected List<class_1113> sounds;

    protected void ofSounds(class_1113 ... sound) {
        if (Arrays.stream(sound).anyMatch(Objects::isNull)) {
            this.sounds = EMPTY;
            return;
        }
        this.sounds = List.of(sound);
    }

    public static SoundHandler create(class_1113 ... list) {
        SoundHandler handler = new SoundHandler();
        handler.sounds = new ArrayList<class_1113>();
        handler.sounds.addAll(List.of(list));
        return handler;
    }

    public void startIfNotPlaying(class_3414 event) {
        if (!this.isPlaying(event)) {
            this.startSound(event);
        }
    }

    public void startIfNotPlaying(class_1113 sound) {
        if (!this.isPlaying(sound)) {
            this.startSound(sound);
        }
    }

    public boolean isPlaying(class_3414 event) {
        return class_310.method_1551().method_1483().method_4877(this.findSoundByEvent(event));
    }

    public boolean isPlaying(class_1113 sound) {
        return class_310.method_1551().method_1483().method_4877(sound);
    }

    public void startSound(class_3414 event) {
        class_1113 sound = this.findSoundByEvent(event);
        if (sound == null || sound.method_4775() == null) {
            return;
        }
        class_310.method_1551().method_1483().method_4873(sound);
    }

    public void startSound(class_1113 sound) {
        if (sound == null || sound.method_4775() == null) {
            return;
        }
        class_310.method_1551().method_1483().method_4873(sound);
    }

    public void stopSound(class_3414 event) {
        class_310.method_1551().method_1483().method_4870(this.findSoundByEvent(event));
    }

    public void stopSound(class_1113 sound) {
        class_310.method_1551().method_1483().method_4870(sound);
    }

    public void stopSounds() {
        if (this.sounds == null) {
            return;
        }
        for (class_1113 sound : this.sounds) {
            this.stopSound(sound);
        }
    }

    public class_1113 findSoundByEvent(class_3414 event) {
        return this.findSoundById(event.method_14833());
    }

    public class_1113 findSoundById(class_2960 id) {
        for (class_1113 sound : this.sounds) {
            class_2960 temp = sound.method_4775();
            if (!temp.equals((Object)id)) continue;
            return sound;
        }
        AITMod.LOGGER.error("Could not find sound {} in list, returning empty sound!", (Object)id);
        return new PlayerFollowingLoopingSound(class_3417.field_42593, class_3419.field_15254);
    }
}

