/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.sounds.flight;

import dev.amble.ait.client.sounds.SoundHandler;
import dev.amble.ait.client.sounds.flight.FlightSoundPlayer;
import dev.amble.ait.client.sounds.flight.InteriorFlightSound;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3419;

public class ClientFlightHandler
extends SoundHandler {
    public static final double MAX_DISTANCE = 16.0;
    public static FlightSoundPlayer FLIGHT;

    public FlightSoundPlayer getFlightLoop(ClientTardis tardis) {
        if (FLIGHT == null) {
            this.generate(tardis);
        }
        return FLIGHT;
    }

    private InteriorFlightSound createFlightSound(ClientTardis tardis) {
        return new InteriorFlightSound(tardis.stats().getFlightEffects(), class_3419.field_15245);
    }

    public static ClientFlightHandler create() {
        return new ClientFlightHandler();
    }

    private void generate(ClientTardis tardis) {
        if (FLIGHT == null) {
            FLIGHT = this.createFlightSound(tardis);
        }
        FLIGHT.refresh();
        this.ofSounds(FLIGHT);
    }

    private void playFlightSound(ClientTardis tardis) {
        this.startIfNotPlaying(this.getFlightLoop(tardis));
        FlightSoundPlayer interior = this.getFlightLoop(tardis);
        interior.method_16896();
        if (interior.isDirty()) {
            interior.setDirty(false);
            if (interior.getData().id().equals((Object)tardis.stats().getFlightEffects().id())) {
                return;
            }
            this.stopSounds();
            class_310.method_1551().method_1483().method_4870((class_1113)FLIGHT);
            FLIGHT = null;
            this.generate(tardis);
        }
    }

    private boolean shouldPlaySounds(ClientTardis tardis) {
        return tardis != null && tardis.fuel().hasPower() && (tardis.travel().inFlight() || this.hasThrottleAndHandbrakeDown(tardis));
    }

    public boolean hasThrottleAndHandbrakeDown(ClientTardis tardis) {
        return tardis != null && tardis.travel().isLanded() && tardis.travel().speed() > 0 && tardis.travel().handbrake();
    }

    public void tick(class_310 client) {
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null) {
            tardis = ClientTardisUtil.getNearestTardis(16.0).orElse(null);
        }
        if (tardis == null) {
            return;
        }
        if (this.sounds == null) {
            this.generate(tardis);
        }
        if (this.shouldPlaySounds(tardis)) {
            this.playFlightSound(tardis);
        } else {
            this.stopSounds();
        }
    }
}

