/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.sounds.hum.exterior;

import dev.amble.ait.api.ClientWorldEvents;
import dev.amble.ait.client.sounds.SoundHandler;
import dev.amble.ait.client.sounds.hum.exterior.ExteriorHumSound;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.handler.ChameleonHandler;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3419;

public class ExteriorHumHandler
extends SoundHandler {
    public static double MAX_DISTANCE = 8.0;
    public static ExteriorHumSound SOUND;

    public ExteriorHumSound getSound(ClientTardis tardis) {
        if (SOUND == null) {
            this.generate(tardis);
        }
        return SOUND;
    }

    private ExteriorHumSound soundFor(ClientTardis tardis) {
        ExteriorHumSound sfx = new ExteriorHumSound(tardis.hum().get(), class_3419.field_15245);
        sfx.link(tardis);
        return sfx;
    }

    public static ExteriorHumHandler create() {
        return new ExteriorHumHandler();
    }

    private void generate(ClientTardis tardis) {
        if (SOUND == null) {
            SOUND = this.soundFor(tardis);
        }
        SOUND.refresh();
        this.ofSounds(new class_1113[]{SOUND});
    }

    private void play(ClientTardis tardis) {
        this.startIfNotPlaying((class_1113)this.getSound(tardis));
        ExteriorHumSound sound = this.getSound(tardis);
        sound.method_16896();
        if (sound.isDirty()) {
            sound.setDirty(false);
            if (sound.isLinked()) {
                sound.setPosition(sound.tardis().get().travel().position().getPos());
                if (sound.getData().id().equals((Object)tardis.hum().get().id())) {
                    return;
                }
            }
            this.stopSounds();
            class_310.method_1551().method_1483().method_4870((class_1113)SOUND);
            SOUND = null;
            this.generate(tardis);
            this.startIfNotPlaying((class_1113)SOUND);
        }
    }

    private boolean shouldPlaySounds(ClientTardis tardis) {
        return tardis != null && tardis.fuel().hasPower();
    }

    public void tick(class_310 client) {
        ClientTardis tardis = ClientTardisUtil.getNearestTardis(MAX_DISTANCE).orElse(null);
        if (tardis == null || ChameleonHandler.isDisguised(tardis) || ((Boolean)tardis.cloak().cloaked().get()).booleanValue()) {
            this.stopSounds();
            return;
        }
        if (!tardis.travel().isLanded()) {
            this.stopSounds();
            return;
        }
        if (this.sounds == null) {
            this.generate(tardis);
        }
        if (this.shouldPlaySounds(tardis)) {
            this.play(tardis);
        } else {
            this.stopSounds();
        }
    }

    static {
        ClientWorldEvents.CHANGE_WORLD.register((client, world) -> {
            if (SOUND != null) {
                class_310.method_1551().method_1483().method_4870((class_1113)SOUND);
            }
            SOUND = null;
        });
    }
}

