/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.sounds.hum.interior;

import dev.amble.ait.api.ClientWorldEvents;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.sounds.ClientSoundManager;
import dev.amble.ait.client.sounds.LoopingSound;
import dev.amble.ait.client.sounds.PlayerFollowingLoopingSound;
import dev.amble.ait.client.sounds.SoundHandler;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.handler.ServerHumHandler;
import dev.amble.ait.data.hum.Hum;
import dev.amble.ait.registry.impl.HumRegistry;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1113;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ClientHumHandler
extends SoundHandler {
    private LoopingSound current;

    protected ClientHumHandler() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerHumHandler.SEND, (client, handler, buf, responseSender) -> {
            class_2960 id = buf.method_10810();
            class_1113 sound = this.findSoundById(id);
            if (sound.method_4775() == class_3417.field_42593.method_14833()) {
                return;
            }
            if (!(sound instanceof LoopingSound)) {
                return;
            }
            LoopingSound hum = (LoopingSound)sound;
            this.setHum(ClientTardisUtil.getCurrentTardis(), hum);
        });
    }

    public void onSynced() {
        this.sounds = this.registryToList();
    }

    public LoopingSound getHum(ClientTardis tardis) {
        if (this.current == null) {
            this.current = (LoopingSound)this.findSoundByEvent(((ServerHumHandler)tardis.handler(TardisComponent.Id.HUM)).get().sound());
        }
        return this.current;
    }

    public void setHum(ClientTardis tardis, LoopingSound hum) {
        LoopingSound previous = this.getHum(tardis);
        this.current = hum;
        this.stopSound((class_1113)previous);
    }

    public void setServersHum(ClientTardis tardis, Hum hum) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(tardis.getUuid());
        buf.method_10812(hum.id());
        ClientPlayNetworking.send((class_2960)ServerHumHandler.RECEIVE, (class_2540)buf);
    }

    public static ClientHumHandler create() {
        ClientHumHandler handler = new ClientHumHandler();
        handler.generateHums();
        return handler;
    }

    private void generateHums() {
        this.sounds = this.registryToList();
    }

    private List<class_1113> registryToList() {
        ArrayList<class_1113> list = new ArrayList<class_1113>();
        for (Hum sound : HumRegistry.getInstance().toList()) {
            list.add((class_1113)new PlayerFollowingLoopingSound(sound.sound(), class_3419.field_15256, AITModClient.CONFIG.interiorHumVolume));
        }
        return list;
    }

    private boolean shouldPlaySounds(ClientTardis tardis) {
        return tardis != null && tardis.fuel().hasPower();
    }

    public void tick(class_310 client) {
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (this.sounds == null) {
            this.generateHums();
        }
        if (this.shouldPlaySounds(tardis)) {
            this.startIfNotPlaying((class_1113)this.getHum(tardis));
        } else {
            this.stopSounds();
        }
    }

    @Override
    public class_1113 findSoundById(class_2960 id) {
        if (this.sounds == null) {
            this.sounds = this.registryToList();
        }
        return super.findSoundById(id);
    }

    static {
        ClientWorldEvents.CHANGE_WORLD.register((client, world) -> {
            if (world == null) {
                return;
            }
            ClientHumHandler handler = ClientSoundManager.getHum();
            handler.stopSounds();
            handler.current = null;
            ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
            if (tardis == null) {
                return;
            }
            handler.getHum(tardis);
        });
    }
}

