/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.sounds.sonic;

import dev.amble.ait.client.sounds.PositionedLoopingSound;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_742;

public class SonicSound
extends PositionedLoopingSound {
    private final class_742 player;
    private boolean hasPlayedOnSound = false;
    private boolean hasPlayedOffSound = false;
    private float lastYaw;
    private float lastPitch;

    public SonicSound(class_742 player) {
        super(AITSounds.SONIC_USE, class_3419.field_15248, player.method_24515(), 1.0f, 1.0f);
        this.player = player;
        this.lastYaw = player.method_36454();
        this.lastPitch = player.method_36455();
    }

    @Override
    public void method_16896() {
        super.method_16896();
        if (!SonicSound.shouldPlay((class_1657)this.player)) {
            this.stop();
            return;
        }
        if (this.checkAndPlayDuelSound()) {
            return;
        }
        this.updatePosition();
        this.updatePitchBasedOnCameraMovement();
    }

    private boolean checkAndPlayDuelSound() {
        class_239 hitResult = this.player.method_5745(16.0, 0.0f, false);
        if (hitResult.method_17783() != class_239.class_240.field_1331) {
            return false;
        }
        class_3966 entityHitResult = (class_3966)hitResult;
        class_1297 class_12972 = entityHitResult.method_17782();
        if (!(class_12972 instanceof class_742)) {
            return false;
        }
        class_742 otherPlayer = (class_742)class_12972;
        if (!SonicSound.shouldPlay((class_1657)otherPlayer)) {
            return false;
        }
        if (!this.hasPlayedOnSound) {
            this.playSoundAtPlayer(AITSounds.SONIC_DUEL);
            this.hasPlayedOnSound = true;
            this.hasPlayedOffSound = false;
            return true;
        }
        return false;
    }

    public static boolean shouldPlay(class_1657 player) {
        return player.method_6115() && player.method_6030().method_31574(AITItems.SONIC_SCREWDRIVER);
    }

    public void play() {
        if (!this.hasPlayedOnSound) {
            this.playSoundAtPlayer(AITSounds.SONIC_ON);
            this.hasPlayedOnSound = true;
            this.hasPlayedOffSound = false;
        }
        class_310.method_1551().method_1483().method_4873((class_1113)this);
    }

    public boolean isPlaying() {
        return class_310.method_1551().method_1483().method_4877((class_1113)this);
    }

    public void stop() {
        class_310.method_1551().method_1483().method_4870((class_1113)this);
        if (!this.hasPlayedOffSound) {
            this.playSoundAtPlayer(AITSounds.SONIC_OFF);
            this.hasPlayedOffSound = true;
            this.hasPlayedOnSound = false;
        }
    }

    private void updatePosition() {
        this.setPosition(this.player.method_24515());
    }

    private void updatePitchBasedOnCameraMovement() {
        float currentYaw = this.player.method_36454();
        float currentPitch = this.player.method_36455();
        float yawChange = Math.abs(currentYaw - this.lastYaw);
        float pitchChange = Math.abs(currentPitch - this.lastPitch);
        float totalCameraSpeed = yawChange + pitchChange;
        float newPitch = 1.2f + totalCameraSpeed * 0.02f;
        newPitch = Math.max(1.2f, Math.min(newPitch, 1.5f));
        this.setPitch(newPitch);
        this.lastYaw = currentYaw;
        this.lastPitch = currentPitch;
    }

    public void onUse() {
        if (!this.isPlaying()) {
            this.play();
        }
    }

    public void onFinishUse() {
        this.stop();
    }

    private void playSoundAtPlayer(class_3414 sound) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            world.method_8486(this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), sound, class_3419.field_15248, 1.0f, 1.0f, false);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SonicSound)) {
            return false;
        }
        SonicSound other = (SonicSound)((Object)obj);
        return this.player != null && other.player != null && this.player.method_5667().equals(other.player.method_5667());
    }
}

