/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.tardis;

import com.google.gson.InstanceCreator;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.util.ClientShakeUtil;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.data.Exclude;
import java.lang.reflect.Type;
import java.util.UUID;
import net.minecraft.class_310;

public class ClientTardis
extends Tardis
implements Disposable {
    @Exclude
    private final UUID check;
    @Exclude
    private boolean aged = false;

    private ClientTardis(UUID check) {
        this.check = check;
    }

    public void setDesktop(TardisDesktop desktop) {
        desktop.setTardis(this);
        this.desktop = desktop;
    }

    public void setExterior(TardisExterior exterior) {
        exterior.setTardis(this);
        this.exterior = exterior;
    }

    public void tick(class_310 client) {
        this.getHandlers().tick(client);
        if (ClientTardisUtil.getCurrentTardis() != this) {
            return;
        }
        ClientTardisUtil.tickPowerDelta();
        ClientTardisUtil.tickAlarmDelta();
        if (!ClientShakeUtil.shouldShake(this)) {
            return;
        }
        if (((Boolean)this.flight().falling().get()).booleanValue()) {
            ClientShakeUtil.shakeFromEverywhere();
        } else {
            ClientShakeUtil.shakeFromConsole();
        }
    }

    @Override
    public <T extends TardisComponent> T handler(TardisComponent.IdLike type) {
        if (this.handlers == null) {
            AITMod.LOGGER.error("Asked for a handler too early on {}, aged? {}", (Object)this, (Object)this.aged);
            return null;
        }
        return super.handler(type);
    }

    @Override
    public void age() {
        this.aged = true;
    }

    @Override
    public boolean isAged() {
        return this.aged;
    }

    @Override
    public void dispose() {
        this.desktop.dispose();
        this.desktop = null;
        this.exterior.dispose();
        this.exterior = null;
        this.handlers.dispose();
        this.handlers = null;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + Integer.toHexString(this.check.hashCode()) + ")";
    }

    public static Object creator() {
        return new ClientTardisCreator();
    }

    static class ClientTardisCreator
    implements InstanceCreator<ClientTardis> {
        ClientTardisCreator() {
        }

        public ClientTardis createInstance(Type type) {
            return new ClientTardis(UUID.randomUUID());
        }
    }
}

