/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.tardis.manager;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.GsonBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.sounds.ClientSoundManager;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.TardisMap;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ClientTardisManager
extends TardisManager<ClientTardis, class_310> {
    private static ClientTardisManager instance;
    private final TardisMap.Direct<ClientTardis> lookup = new TardisMap.Direct();
    private final Multimap<UUID, Consumer<ClientTardis>> subscribers = ArrayListMultimap.create();

    public static void init() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new UnsupportedOperationException("Tried to initialize ClientTardisManager on the server!");
        }
        instance = new ClientTardisManager();
    }

    private ClientTardisManager() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SEND, (client, handler, buf, responseSender) -> this.syncTardis(buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SEND_BULK, (client, handler, buf, responseSender) -> this.syncBulk(buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)REMOVE, (client, handler, buf, responseSender) -> this.remove(buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SEND_COMPONENT, (client, handler, buf, responseSender) -> this.syncDelta(buf));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            for (ClientTardis tardis : this.lookup.values()) {
                tardis.tick(client);
            }
            ClientSoundManager.tick(client);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.reset());
        ClientLoginConnectionEvents.DISCONNECT.register((client, reason) -> this.reset());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.reset());
    }

    public void sendProperty(Value<?> value) {
        class_2540 buf = PacketByteBufs.create();
        TardisComponent holder = value.getHolder();
        buf.method_10797(holder.tardis().getUuid());
        buf.method_10814(holder.getId().name());
        buf.method_10814(value.getProperty().getName());
        value.write(buf);
        ClientPlayNetworking.send((class_2960)SEND_PROPERTY, (class_2540)buf);
    }

    private void remove(class_2540 buf) {
        this.lookup.remove(buf.method_10790());
    }

    @Override
    protected TardisMap.Direct<ClientTardis> lookup() {
        return this.lookup;
    }

    @Override
    @Deprecated
    @Nullable
    public ClientTardis demandTardis(class_310 client, UUID uuid) {
        Objects.requireNonNull(uuid);
        return (ClientTardis)this.lookup.get(uuid);
    }

    @Deprecated
    @Nullable
    public ClientTardis demandTardis(UUID uuid) {
        return this.demandTardis(class_310.method_1551(), uuid);
    }

    public void getTardis(UUID uuid, Consumer<ClientTardis> consumer) {
        this.getTardis(class_310.method_1551(), uuid, consumer);
    }

    private void syncTardis(UUID uuid, String json) {
        try {
            ClientTardis tardis = (ClientTardis)this.networkGson.fromJson(json, ClientTardis.class);
            Tardis.init(tardis, TardisComponent.InitContext.deserialize());
            ClientTardis old = this.lookup.put(tardis);
            if (old != null) {
                old.age();
            }
            for (Consumer consumer : this.subscribers.removeAll((Object)uuid)) {
                consumer.accept(tardis);
            }
        }
        catch (Throwable t) {
            AITMod.LOGGER.error("Received malformed JSON file {}", (Object)json);
            AITMod.LOGGER.error("Failed to deserialize TARDIS data: ", t);
        }
    }

    private void syncTardis(class_2540 buf) {
        this.syncTardis(buf.method_10790(), buf.method_19772());
    }

    private void syncBulk(class_2540 buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.syncTardis(buf);
        }
    }

    private void syncComponent(ClientTardis tardis, class_2540 buf) {
        String rawId = buf.method_19772();
        TardisComponent.IdLike id = TardisComponentRegistry.getInstance().get(rawId);
        TardisComponent component = (TardisComponent)this.networkGson.fromJson(buf.method_19772(), id.clazz());
        id.set(tardis, component);
        TardisComponent.init(component, tardis, TardisComponent.InitContext.deserialize());
    }

    private void syncDelta(class_2540 buf) {
        UUID id = buf.method_10790();
        int count = buf.readShort();
        ClientTardis tardis = this.demandTardis(id);
        TardisComponent[] components = new TardisComponent[count];
        TardisComponent.IdLike[] ids = new TardisComponent.IdLike[count];
        if (tardis == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            TardisComponent.IdLike idLike;
            String rawId = buf.method_19772();
            ids[i] = idLike = TardisComponentRegistry.getInstance().get(rawId);
            TardisComponent component = (TardisComponent)this.networkGson.fromJson(buf.method_19772(), idLike.clazz());
            if (component == null) {
                AITMod.LOGGER.error("Received null component for id {} in TARDIS {}", (Object)rawId, (Object)tardis.getUuid());
                continue;
            }
            components[i] = component;
        }
        class_310.method_1551().execute(() -> {
            for (int p = 0; p < components.length; ++p) {
                TardisComponent component = components[p];
                TardisComponent.IdLike idLike = ids[p];
                idLike.set(tardis, component);
                TardisComponent.init(component, tardis, TardisComponent.InitContext.deserialize());
            }
        });
    }

    @Override
    protected GsonBuilder createGsonBuilder(Exclude.Strategy strategy) {
        return super.createGsonBuilder(strategy).registerTypeAdapter(ClientTardis.class, ClientTardis.creator());
    }

    @Override
    public void getTardis(class_310 client, UUID uuid, Consumer<ClientTardis> consumer) {
        if (uuid == null) {
            return;
        }
        ClientTardis result = (ClientTardis)this.lookup().get(uuid);
        if (result == null) {
            return;
        }
        consumer.accept(result);
    }

    @Override
    public void reset() {
        this.subscribers.clear();
        this.forEach(ClientTardis::dispose);
        super.reset();
    }

    @Override
    public void forEach(Consumer<ClientTardis> consumer) {
        this.lookup.forEach((? super K uuid, ? super V tardis) -> consumer.accept((ClientTardis)tardis));
    }

    public static ClientTardisManager getInstance() {
        return instance;
    }
}

