/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.util;

import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ClientShakeUtil {
    private static final float SHAKE_CLAMP = 45.0f;
    private static final float SHAKE_INTENSITY = 0.5f;
    private static final int MAX_DISTANCE = 16;

    public static boolean shouldShake(Tardis tardis) {
        if (ClientTardisUtil.getCurrentTardis() != tardis) {
            return false;
        }
        if (((Boolean)tardis.flight().falling().get()).booleanValue()) {
            return true;
        }
        return !tardis.travel().autopilot() && tardis.travel().getState() != TravelHandlerBase.State.LANDED;
    }

    public static void shakeFromConsole() {
        ClientShakeUtil.shake(1.0f - (float)(ClientTardisUtil.distanceFromConsole() / 16.0));
    }

    public static void shakeFromEverywhere() {
        ClientShakeUtil.shake(0.1f);
    }

    public static void shake(float scale) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        float targetPitch = ClientShakeUtil.getShakeX(client.field_1724.method_36455(), scale);
        float targetYaw = ClientShakeUtil.getShakeY(client.field_1724.method_36454(), scale);
        client.field_1724.method_36457(class_3532.method_16439((float)0.5f, (float)client.field_1724.method_36455(), (float)targetPitch));
        client.field_1724.method_36456(class_3532.method_16439((float)0.5f, (float)client.field_1724.method_36454(), (float)targetYaw));
    }

    private static float getShakeY(float baseYaw, float scale) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return baseYaw;
        }
        float temp = client.field_1724.method_6051().method_43057() * scale;
        float shakeYaw = baseYaw + (client.field_1724.method_6051().method_43056() ? temp : -temp);
        return class_3532.method_15363((float)shakeYaw, (float)(baseYaw - 45.0f), (float)(baseYaw + 45.0f));
    }

    private static float getShakeX(float basePitch, float scale) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return basePitch;
        }
        float temp = client.field_1724.method_6051().method_43057() * (scale / 2.0f);
        float shakePitch = basePitch + (client.field_1724.method_6051().method_43056() ? temp : -temp);
        return class_3532.method_15363((float)shakePitch, (float)(basePitch - 45.0f), (float)(basePitch + 45.0f));
    }
}

