/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.util;

import dev.amble.ait.api.ClientWorldEvents;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.tardis.manager.ClientTardisManager;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.core.tardis.handler.SonicHandler;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ClientTardisUtil {
    public static final int MAX_POWER_DELTA_TICKS = 60;
    public static final int MAX_ALARM_DELTA_TICKS = 60;
    private static int alarmDeltaTick;
    private static boolean alarmDeltaDirection;
    private static int powerDeltaTick;
    private static TardisRef currentTardis;

    public static void changeExteriorWithScreen(UUID uuid, class_2960 variant, boolean variantchange) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        buf.writeBoolean(variantchange);
        buf.method_10812(variant);
        ClientPlayNetworking.send((class_2960)TardisExterior.CHANGE_EXTERIOR, (class_2540)buf);
    }

    public static void changeExteriorWithScreen(ClientTardis tardis, class_2960 variant, boolean variantchange) {
        ClientTardisUtil.changeExteriorWithScreen(tardis.getUuid(), variant, variantchange);
    }

    public static void changeSonicWithScreen(UUID uuid, SonicSchema schema, class_2338 consolePos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        buf.method_10812(schema.id());
        buf.method_10807(consolePos);
        ClientPlayNetworking.send((class_2960)SonicHandler.CHANGE_SONIC, (class_2540)buf);
    }

    public static void snapToOpenDoors(Tardis tardis) {
        ClientTardisUtil.snapToOpenDoors(tardis.getUuid());
    }

    public static void snapToOpenDoors(UUID uuid) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        ClientPlayNetworking.send((class_2960)TardisUtil.SNAP, (class_2540)buf);
    }

    public static void flyingSpeedPacket(Tardis tardis, String direction) {
        ClientTardisUtil.flyingSpeedPacket(tardis.getUuid(), direction);
    }

    public static void flyingSpeedPacket(UUID uuid, String direction) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        buf.method_10814(direction);
        ClientPlayNetworking.send((class_2960)TardisUtil.FLYING_SPEED, (class_2540)buf);
    }

    public static void toggleAntigravs(Tardis tardis) {
        ClientTardisUtil.toggleAntigravs(tardis.getUuid());
    }

    public static void toggleAntigravs(UUID uuid) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        ClientPlayNetworking.send((class_2960)TardisUtil.TOGGLE_ANTIGRAVS, (class_2540)buf);
    }

    public static boolean isPlayerInATardis() {
        return currentTardis != null;
    }

    public static ClientTardis getCurrentTardis() {
        if (currentTardis == null) {
            return null;
        }
        return (ClientTardis)currentTardis.get();
    }

    public static Optional<ClientTardis> getNearestTardis(double radius) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return Optional.empty();
        }
        class_2338 pos = player.method_24515();
        class_5321 dimension = player.method_37908().method_27983();
        double radiusSquared = Math.pow(radius, 2.0);
        ClientTardis[] nearestTardis = new ClientTardis[1];
        double[] nearestDistanceSquared = new double[]{Double.MAX_VALUE};
        ClientTardisManager.getInstance().forEach(tardis -> {
            if (!tardis.travel().position().getDimension().equals(dimension)) {
                return;
            }
            class_2338 tPos = tardis.travel().position().getPos();
            double distanceSquared = pos.method_10262((class_2382)tPos);
            if (radiusSquared > distanceSquared && distanceSquared < nearestDistanceSquared[0]) {
                nearestDistanceSquared[0] = distanceSquared;
                nearestTardis[0] = tardis;
            }
        });
        return Optional.ofNullable(nearestTardis[0]);
    }

    public static double distanceFromConsole() {
        if (!ClientTardisUtil.isPlayerInATardis()) {
            return 0.0;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return 0.0;
        }
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null) {
            return 0.0;
        }
        Set<class_2338> consoles = tardis.getDesktop().getConsolePos();
        if (consoles.isEmpty()) {
            return 0.0;
        }
        class_2338 pos = player.method_24515();
        double lowest = Double.MAX_VALUE;
        for (class_2338 console : consoles) {
            double distance = Math.sqrt(pos.method_10262((class_2382)console));
            if (!(distance < lowest)) continue;
            lowest = distance;
        }
        return lowest;
    }

    public static class_2338 getNearestConsole() {
        if (!ClientTardisUtil.isPlayerInATardis()) {
            return class_2338.field_10980;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return class_2338.field_10980;
        }
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null) {
            return class_2338.field_10980;
        }
        class_2338 pos = player.method_24515();
        double lowest = Double.MAX_VALUE;
        class_2338 nearest = class_2338.field_10980;
        for (class_2338 console : tardis.getDesktop().getConsolePos()) {
            double distance = Math.sqrt(pos.method_10262((class_2382)console));
            if (!(distance < lowest)) continue;
            lowest = distance;
            nearest = console;
        }
        return nearest;
    }

    public static class_2338 getNearestEngine() {
        double distance;
        if (!ClientTardisUtil.isPlayerInATardis()) {
            return null;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return null;
        }
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null) {
            return null;
        }
        class_2338 pos = player.method_24515();
        double lowest = Double.MAX_VALUE;
        class_2338 nearest = class_2338.field_10980;
        class_2338 engine = tardis.getDesktop().getEnginePos();
        if (engine != null && (distance = Math.sqrt(pos.method_10262((class_2382)engine))) < lowest) {
            lowest = distance;
            nearest = engine;
        }
        return nearest;
    }

    public static void tickPowerDelta() {
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null) {
            powerDeltaTick = 60;
            return;
        }
        if (tardis.fuel().hasPower() && ClientTardisUtil.getPowerDelta() < 60) {
            ++powerDeltaTick;
        } else if (!tardis.fuel().hasPower() && ClientTardisUtil.getPowerDelta() > 0) {
            --powerDeltaTick;
        }
    }

    public static int getPowerDelta() {
        return currentTardis != null ? powerDeltaTick : 0;
    }

    public static float getPowerDeltaForLerp() {
        return (float)ClientTardisUtil.getPowerDelta() / 60.0f;
    }

    public static void tickAlarmDelta() {
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null || !tardis.alarm().isEnabled()) {
            alarmDeltaTick = 60;
            return;
        }
        if (alarmDeltaTick < 60 && alarmDeltaDirection) {
            ++alarmDeltaTick;
        } else if (alarmDeltaTick > 0 && !alarmDeltaDirection) {
            --alarmDeltaTick;
        }
        if (alarmDeltaTick >= 60) {
            alarmDeltaDirection = false;
        }
        if (alarmDeltaTick == 0) {
            alarmDeltaDirection = true;
        }
    }

    public static int getAlarmDelta() {
        if (!ClientTardisUtil.isPlayerInATardis()) {
            return 0;
        }
        return alarmDeltaTick;
    }

    public static float getAlarmDeltaForLerp() {
        return (float)ClientTardisUtil.getAlarmDelta() / 60.0f;
    }

    public static float[] getPartyColors() {
        int m = 25;
        class_746 player = class_310.method_1551().field_1724;
        int n = player.field_6012 / 25 + player.method_5628();
        int o = class_1767.values().length;
        int p = n % o;
        int q = (n + 1) % o;
        float r = (float)(player.field_6012 % 25) / 25.0f;
        float[] fs = class_1472.method_6634((class_1767)class_1767.method_7791((int)p));
        float[] gs = class_1472.method_6634((class_1767)class_1767.method_7791((int)q));
        float s = fs[0] * (1.0f - r) + gs[0] * r;
        float t = fs[1] * (1.0f - r) + gs[1] * r;
        float u = fs[2] * (1.0f - r) + gs[2] * r;
        return new float[]{s, t, u};
    }

    static {
        ClientWorldEvents.CHANGE_WORLD.register((client, world) -> {
            UUID id = TardisServerWorld.getTardisId((class_1937)world);
            currentTardis = new TardisRef(id, uuid -> ClientTardisManager.getInstance().demandTardis((UUID)uuid));
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            UUID id = TardisServerWorld.getTardisId((class_1937)client.field_1687);
            currentTardis = new TardisRef(id, uuid -> ClientTardisManager.getInstance().demandTardis((UUID)uuid));
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            currentTardis = null;
        });
    }
}

