/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.renderers.VortexRender;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.module.planet.client.renderers.CelestialBodyRenderer;
import dev.amble.ait.module.planet.client.renderers.SpaceSkyRenderer;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetRenderInfo;
import dev.amble.ait.module.planet.core.space.system.SolarSystem;
import dev.amble.ait.module.planet.core.space.system.Space;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class SkyboxUtil
extends class_761 {
    private static final class_2960 TARDIS_SKY = AITMod.id("textures/environment/tardis_sky.png");
    private static final class_2960 SUN = AITMod.id("textures/environment/tardis_star.png");
    public static final Quaternionf[] LOOKUP = new Quaternionf[]{null, class_7833.field_40714.rotationDegrees(90.0f), class_7833.field_40714.rotationDegrees(-90.0f), class_7833.field_40714.rotationDegrees(180.0f), class_7833.field_40718.rotationDegrees(90.0f), class_7833.field_40718.rotationDegrees(-90.0f), null};

    public SkyboxUtil(class_310 client, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 bufferBuilders) {
        super(client, entityRenderDispatcher, blockEntityRenderDispatcher, bufferBuilders);
    }

    public static void renderVortexSky(class_4587 matrices, Tardis tardis) {
        VortexRender util = tardis.stats().getVortexEffects().toRender();
        matrices.method_22903();
        float scale = 100.0f;
        float zOffset = 500.0f * scale;
        if (!tardis.travel().autopilot() && tardis.travel().getState() != TravelHandlerBase.State.LANDED) {
            matrices.method_22907(class_7833.field_40715.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / (200.0f / (float)tardis.travel().speed()) * 360.0f));
        }
        if (!tardis.crash().isNormal()) {
            matrices.method_22907(class_7833.field_40714.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / 100.0f * 360.0f));
        }
        matrices.method_22907(class_7833.field_40718.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / 100.0f * 360.0f));
        matrices.method_46416(0.0f, 0.0f, zOffset);
        matrices.method_22905(scale, scale, scale);
        util.render(matrices);
        matrices.method_22909();
    }

    public static void renderVortexSky(class_4587 matrices) {
        VortexRender util = VortexRender.getCurrentInstance();
        matrices.method_22903();
        float scale = 100.0f;
        float zOffset = 500.0f * scale;
        matrices.method_22907(class_7833.field_40715.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / 40.0f * 360.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / 100.0f * 360.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / 100.0f * 360.0f));
        matrices.method_46416(0.0f, 0.0f, zOffset);
        matrices.method_22905(scale, scale, scale);
        util.render(matrices);
        matrices.method_22909();
    }

    public static void renderTardisSky(class_4587 matrices) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)TARDIS_SKY);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        for (int i = 0; i < 6; ++i) {
            matrices.method_22903();
            Quaternionf rot = LOOKUP[i];
            if (rot != null) {
                matrices.method_22907(rot);
            }
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(40, 40, 40, 255).method_1344();
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_1336(40, 40, 40, 255).method_1344();
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_1336(40, 40, 40, 255).method_1344();
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_1336(40, 40, 40, 255).method_1344();
            tessellator.method_1350();
            matrices.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void renderMoonSky(class_4587 matrices, Runnable fogCallback, class_291 starsBuffer, class_638 world, float tickDelta, Matrix4f projectionMatrix) {
        SkyboxUtil.renderMoonSky(0.0f, matrices, fogCallback, starsBuffer, world, tickDelta, projectionMatrix);
    }

    public static void renderMoonSky(float tallDrinkOfWater, class_4587 matrices, Runnable fogCallback, class_291 starsBuffer, class_638 world, float tickDelta, Matrix4f projectionMatrix) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-405.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(world.method_30274(tickDelta) * 360.0f + 300.0f));
        matrices.method_22905(100.0f, 100.0f, 100.0f);
        SkyboxUtil.drawSpace(tessellator, bufferBuilder, matrices);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(world.method_30274(tickDelta) * 360.0f));
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        class_758.method_23792();
        starsBuffer.method_1353();
        starsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
        class_291.method_1354();
        fogCallback.run();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.depthFunc((int)519);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        matrices.method_22909();
        matrices.method_22909();
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        matrices.method_22903();
        SkyboxUtil.renderStarBody(false, matrices, SUN, new class_243(cameraPos.method_10216() + 270.0, cameraPos.method_10214() - 120.0, cameraPos.method_10215() + 0.0), new Vector3f(12.0f, 12.0f, 12.0f), new Vector3f(12.0f, 45.0f, 0.0f), true, new Vector3f(0.3f, 0.15f, 0.01f));
        SkyboxUtil.renderSkyBody(tallDrinkOfWater + (class_2350.method_10150((double)tallDrinkOfWater).equals((Object)class_2350.field_11039) || class_2350.method_10150((double)tallDrinkOfWater).equals((Object)class_2350.field_11034) ? -90.0f : 90.0f), false, matrices, AITMod.id("textures/environment/earth.png"), new class_243(cameraPos.method_10216() - 530.0, cameraPos.method_10214() + 40.0, cameraPos.method_10215() + 10.0), new Vector3f(76.0f, 76.0f, 76.0f), new Vector3f(-22.5f, 45.0f, 0.0f), true, true, new Vector3f(0.18f, 0.35f, 0.6f));
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)513);
        matrices.method_22909();
    }

    public static void renderMarsSky(class_4587 matrices, Runnable fogCallback, class_291 starsBuffer, class_638 world, float tickDelta, Matrix4f projectionMatrix, CallbackInfo ci) {
        float i;
        fogCallback.run();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        class_243 vec3d = world.method_23777(class_310.method_1551().field_1773.method_19418().method_19326(), tickDelta);
        float f = (float)vec3d.field_1352;
        float g = (float)vec3d.field_1351;
        float h = (float)vec3d.field_1350;
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        class_291.method_1354();
        RenderSystem.enableBlend();
        float[] fs = world.method_28103().method_28109(world.method_30274(tickDelta), tickDelta);
        if (fs != null) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            i = class_3532.method_15374((float)world.method_8442(tickDelta)) < 0.0f ? 180.0f : 0.0f;
            matrices.method_22907(class_7833.field_40718.rotationDegrees(i));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            float j = fs[0];
            float k = fs[1];
            float l = fs[2];
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(j, k, l, fs[3]).method_1344();
            int m = 16;
            for (int n = 0; n <= 16; ++n) {
                float o = (float)n * ((float)Math.PI * 2) / 16.0f;
                float p = class_3532.method_15374((float)o);
                float q = class_3532.method_15362((float)o);
                bufferBuilder.method_22918(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).method_22915(fs[0], fs[1], fs[2], 0.0f).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            matrices.method_22909();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-405.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(world.method_30274(tickDelta) * 360.0f + 300.0f));
        matrices.method_22905(100.0f, 100.0f, 100.0f);
        if (fs != null) {
            RenderSystem.setShaderColor((float)(fs[0] + 0.45f), (float)(fs[1] + 0.45f), (float)(fs[2] + 0.45f), (float)0.1f);
        } else {
            RenderSystem.setShaderColor((float)0.8f, (float)1.0f, (float)1.0f, (float)0.1f);
        }
        SpaceSkyRenderer cubeMap = new SpaceSkyRenderer(AITMod.id("textures/environment/space_sky/panorama"));
        cubeMap.draw(tessellator, bufferBuilder, matrices);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        class_758.method_23792();
        starsBuffer.method_1353();
        starsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
        class_291.method_1354();
        fogCallback.run();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)519);
        RenderSystem.defaultBlendFunc();
        matrices.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22909();
        matrices.method_22903();
        i = 1.0f;
        if (fs != null) {
            RenderSystem.setShaderColor((float)(fs[0] + 0.45f), (float)(fs[1] + 0.45f), (float)(fs[2] + 0.45f), (float)i);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)i);
        }
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        SkyboxUtil.renderStarBody(false, matrices, SUN, new class_243(cameraPos.method_10216(), cameraPos.method_10214() + 250.0, cameraPos.method_10215() + 0.0), new Vector3f(6.0f, 6.0f, 6.0f), new Vector3f(45.0f, 12.0f, 12.0f), false, new Vector3f(0.0f, 0.03f, 0.03f));
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrices.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        ci.cancel();
    }

    public static void renderSpaceSky(boolean isTardisSkybox, class_4587 matrices, Runnable fogCallback, class_291 starsBuffer, class_638 world, float tickDelta, Matrix4f projectionMatrix) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-405.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(300.0f));
        matrices.method_22905(100.0f, 100.0f, 100.0f);
        SkyboxUtil.drawSpace(tessellator, bufferBuilder, matrices);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.depthFunc((int)519);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(world.method_30274(tickDelta) * 360.0f));
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        class_758.method_23792();
        starsBuffer.method_1353();
        starsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
        class_291.method_1354();
        fogCallback.run();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        matrices.method_22909();
        RenderSystem.depthFunc((int)514);
        matrices.method_22909();
        SkyboxUtil.renderStarBody(isTardisSkybox, matrices, SUN, new class_243(0.0, 1000.0, 0.0), new Vector3f(1000.0f, 1000.0f, 1000.0f), new Vector3f(12.0f, 45.0f, 0.0f), true, new Vector3f(0.1f, 0.05f, 0.0f));
        for (SolarSystem system : Space.getInstance().systems) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.depthFunc((int)513);
            for (Planet planet : system) {
                PlanetRenderInfo render = planet.render();
                if (render.isEmpty()) continue;
                SkyboxUtil.renderCelestialBody(isTardisSkybox, matrices, render.texture(), render.position(), render.scale(), render.rotation(), render.clouds(), render.atmosphere(), render.color(), render.hasRings());
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderSkyBody(boolean isTardisSkybox, class_4587 matrices, class_2960 texture, class_243 position, Vector3f scale, Vector3f rotation, boolean clouds, boolean atmosphere, Vector3f color) {
        matrices.method_22903();
        CelestialBodyRenderer.renderComprehendableBody(isTardisSkybox, position, scale, rotation, texture, true, clouds, atmosphere, color, false);
        matrices.method_22909();
    }

    private static void renderSkyBody(float rotationOf, boolean isTardisSkybox, class_4587 matrices, class_2960 texture, class_243 position, Vector3f scale, Vector3f rotation, boolean clouds, boolean atmosphere, Vector3f color) {
        matrices.method_22903();
        CelestialBodyRenderer.renderComprehendableBody(rotationOf, isTardisSkybox, position, scale, rotation, texture, true, clouds, atmosphere, color, false);
        matrices.method_22909();
    }

    private static void renderCelestialBody(boolean isTardisSkybox, class_4587 matrices, class_2960 texture, class_243 position, Vector3f scale, Vector3f rotation, boolean clouds, boolean atmosphere, Vector3f color, boolean hasRings) {
        matrices.method_22903();
        CelestialBodyRenderer.renderComprehendableBody(isTardisSkybox, position, scale, rotation, texture, false, clouds, atmosphere, color, hasRings);
        matrices.method_22909();
    }

    private static void renderStarBody(boolean isTardisSkybox, class_4587 matrices, class_2960 texture, class_243 position, Vector3f scale, Vector3f rotation, boolean atmosphere, Vector3f color) {
        matrices.method_22903();
        CelestialBodyRenderer.renderStarBody(isTardisSkybox, position, scale, rotation, texture, atmosphere, color);
        matrices.method_22909();
    }

    private static void drawSpace(class_289 tessellator, class_287 bufferBuilder, class_4587 matrices) {
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        SpaceSkyRenderer cubeMap = new SpaceSkyRenderer(AITMod.id("textures/environment/space_sky/panorama"));
        cubeMap.draw(tessellator, bufferBuilder, matrices);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

