/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.compat;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_4494;

public class DependencyChecker {
    private static final boolean HAS_PORTALS = DependencyChecker.doesModExist("imm_ptl_core");
    private static final boolean HAS_IRIS = DependencyChecker.doesModExist("iris");
    private static final boolean HAS_GRAVITY = DependencyChecker.doesModExist("gravity_changer_q");
    private static final boolean HAS_INDIUM = DependencyChecker.doesModExist("indium");
    private static final boolean HAS_PERMISSION_API = DependencyChecker.doesModExist("fabric-permissions-api");
    private static Boolean NVIDIA_CARD;
    private static Boolean MAC_OS;

    public static boolean doesModExist(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static boolean hasPortals() {
        return HAS_PORTALS;
    }

    public static boolean hasIris() {
        return HAS_IRIS;
    }

    public static boolean hasGravity() {
        return HAS_GRAVITY;
    }

    public static boolean hasIndium() {
        return HAS_INDIUM;
    }

    public static boolean hasPermissionApi() {
        return HAS_PERMISSION_API;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean hasNvidiaCard() {
        if (NVIDIA_CARD == null) {
            NVIDIA_CARD = class_4494.method_22088().toLowerCase().contains("nvidia");
        }
        return NVIDIA_CARD;
    }

    public static boolean hasMacOs() {
        if (MAC_OS == null) {
            String os = System.getProperty("os.name");
            MAC_OS = os != null && (os.contains("mac") || os.contains("darwin"));
        }
        return MAC_OS;
    }
}

