/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.compat.gravity;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisClientEvents;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.client.screens.interior.InteriorSettingsScreen;
import dev.amble.ait.client.screens.widget.DynamicPressableTextWidget;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import gravity_changer.EntityTags;
import gravity_changer.api.GravityChangerAPI;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5575;
import net.minecraft.server.MinecraftServer;

public class GravityHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final class_2960 SYNC = AITMod.id("sync_gravity");
    private static final Property<class_2350> DIRECTION = new Property<class_2350>(Property.DIRECTION, "direction", class_2350.field_11033);
    private final Value<class_2350> direction = DIRECTION.create((class_2350)this);
    @Exclude
    private class_2350 tempDirection = class_2350.field_11033;
    static final TardisComponent.IdLike ID = new TardisComponent.AbstractId<GravityHandler>("GRAVITY", GravityHandler::new, GravityHandler.class);

    public GravityHandler() {
        super(ID);
    }

    @Override
    public void onLoaded() {
        this.direction.of(this, DIRECTION);
        this.tempDirection = class_2350.field_11033;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 20 == 0) {
            this.onTick();
        }
    }

    private void onTick() {
        for (class_1297 entity : this.tardis.asServer().world().method_18198(class_5575.method_31795(class_1309.class), EntityTags::canChangeGravity)) {
            GravityChangerAPI.getGravityComponent((class_1297)entity).setBaseGravityDirection(this.direction.get());
        }
    }

    private static void syncToServer(Tardis tardis, class_2350 direction) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(tardis.getUuid());
        buf.method_10817((Enum)direction);
        ClientPlayNetworking.send((class_2960)SYNC, (class_2540)buf);
    }

    private static class_2350 nextDirection(class_2350 direction) {
        class_2350[] values = class_2350.values();
        int size = values.length;
        int nextIndex = direction.ordinal() + 1;
        if (nextIndex == size) {
            nextIndex = 0;
        }
        return values[nextIndex];
    }

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SYNC, (ServerPlayNetworking.PlayChannelHandler)ServerTardisManager.receiveTardis((tardis, server, player, handler, buf, responseSender) -> {
            if (tardis == null) {
                return;
            }
            GravityHandler gravity = (GravityHandler)tardis.handler(ID);
            class_2350 direction = (class_2350)buf.method_10818(class_2350.class);
            gravity.direction.set(direction);
        }));
        TardisComponentRegistry.getInstance().register(ID);
        TardisEvents.LEAVE_TARDIS.register((tardis, entity) -> GravityChangerAPI.getGravityComponent((class_1297)entity).setBaseGravityDirection(class_2350.field_11033));
    }

    public static void clientInit() {
        TardisClientEvents.SETTINGS_SETUP.register(GravityHandler::setup);
    }

    private static void setup(InteriorSettingsScreen screen) {
        screen.createAnyDynamicButton(button -> GravityHandler.buttonText(screen, button), (x, y, width, height, text, onPress, textRenderer) -> new DynamicPressableTextWidget(x, y, 80, height, text, onPress, textRenderer), button -> GravityHandler.onButton(screen, (DynamicPressableTextWidget)button));
    }

    private static class_2561 buttonText(InteriorSettingsScreen screen, DynamicPressableTextWidget button) {
        GravityHandler gravity = (GravityHandler)screen.tardis().handler(ID);
        boolean isChanged = !button.isLeftClick() || gravity.tempDirection != gravity.direction.get();
        class_2350 direction = isChanged ? gravity.tempDirection : gravity.direction.get();
        class_124 formatting = isChanged ? class_124.field_1054 : class_124.field_1068;
        return class_2561.method_43469((String)"screen.ait.gravity", (Object[])new Object[]{GravityHandler.capitalize(direction.method_10151())}).method_27692(formatting);
    }

    private static void onButton(InteriorSettingsScreen screen, DynamicPressableTextWidget button) {
        ClientTardis tardis = screen.tardis();
        GravityHandler gravity = (GravityHandler)((Tardis)tardis).handler(ID);
        if (button.isLeftClick()) {
            gravity.direction.set(gravity.tempDirection, false);
            button.refresh();
            GravityHandler.syncToServer(tardis, gravity.tempDirection);
            return;
        }
        gravity.tempDirection = GravityHandler.nextDirection(gravity.tempDirection);
        button.refresh();
    }

    private static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

