/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.compat.portal;

import dev.amble.ait.AITMod;
import dev.amble.ait.compat.portal.PortalsAPI;
import java.util.Optional;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6367;
import net.minecraft.class_7924;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalVisualizerUtil {
    public static final class_2960 OPEN_VISUALIZER = AITMod.id("ip/visualizer/open");
    public static final class_2960 CLOSE_VISUALIZER = AITMod.id("ip/visualizer/close");
    @Environment(value=EnvType.CLIENT)
    private static class_276 frameBuffer;
    private static final WeakHashMap<class_3222, ChunkLoader> chunkLoaderMap;

    public static void init() {
        PortalsAPI.VISUALIZER = Optional.of(PortalVisualizerUtil::open);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CLOSE_VISUALIZER, (server, player, handler, buf, sender) -> server.execute(() -> PortalVisualizerUtil.removeChunkLoaderFor(player)));
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientInit() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)OPEN_VISUALIZER, (client, handler, buf, sender) -> {
            class_5321 dim = buf.method_44112(class_7924.field_41223);
            class_2338 pos = buf.method_10811();
            client.execute(() -> {
                if (frameBuffer == null) {
                    frameBuffer = new class_6367(2, 2, true, true);
                }
                client.method_1507((class_437)new GuiPortalScreen((class_5321<class_1937>)dim, pos.method_46558()));
            });
        });
    }

    private static void removeChunkLoaderFor(class_3222 player) {
        ChunkLoader chunkLoader = chunkLoaderMap.remove(player);
        if (chunkLoader != null) {
            PortalAPI.removeChunkLoaderForPlayer((class_3222)player, (ChunkLoader)chunkLoader);
        }
    }

    public static void open(class_3222 player, class_3218 world, class_2338 pos) {
        PortalVisualizerUtil.removeChunkLoaderFor(player);
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos(world.method_27983(), new class_1923(pos)), 8);
        PortalAPI.addChunkLoaderForPlayer((class_3222)player, (ChunkLoader)chunkLoader);
        chunkLoaderMap.put(player, chunkLoader);
        class_2540 buf = PacketByteBufs.create();
        buf.method_44116(world.method_27983());
        buf.method_10807(pos);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OPEN_VISUALIZER, (class_2540)buf);
    }

    static {
        chunkLoaderMap = new WeakHashMap();
    }

    @Environment(value=EnvType.CLIENT)
    public static class GuiPortalScreen
    extends class_437 {
        private static final class_2960 TEXTURE = AITMod.id("textures/gui/tardis/monitor/visualizer_menu.png");
        private static final class_2960 OVERLAY = AITMod.id("textures/gui/tardis/monitor/visualizer_overlay.png");
        private static final int bgHeight = 154;
        private static final int bgWidth = 256;
        private static final int bgBorder = 9;
        private final class_5321<class_1937> viewingDimension;
        private final class_243 viewingPosition;

        public GuiPortalScreen(class_5321<class_1937> viewingDimension, class_243 viewingPosition) {
            super((class_2561)class_2561.method_43471((String)"screen.ait.visualizer.title"));
            this.viewingDimension = viewingDimension;
            this.viewingPosition = viewingPosition;
        }

        public void method_25419() {
            super.method_25419();
            ClientPlayNetworking.send((class_2960)CLOSE_VISUALIZER, (class_2540)PacketByteBufs.create());
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            int top = (this.field_22790 - 154) / 2;
            int left = (this.field_22789 - 256) / 2;
            context.method_25302(TEXTURE, left, top, 0, 0, 256, 154);
            double t1 = CHelper.getSmoothCycles((long)503L);
            Matrix4f cameraTransformation = new Matrix4f();
            cameraTransformation.identity();
            cameraTransformation.mul((Matrix4fc)DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 1.0, 0.0).method_1029(), (double)(t1 * 360.0)).toMatrix());
            WorldRenderInfo worldRenderInfo = new WorldRenderInfo.Builder().setWorld(ClientWorldLoader.getWorld(this.viewingDimension)).setCameraPos(this.viewingPosition).setCameraTransformation(cameraTransformation).setOverwriteCameraTransformation(true).setDescription(null).setRenderDistance(this.field_22787.field_1690.method_38521()).setDoRenderHand(false).setEnableViewBobbing(false).setDoRenderSky(false).setHasFog(false).build();
            GuiPortalRendering.submitNextFrameRendering((WorldRenderInfo)worldRenderInfo, (class_276)frameBuffer);
            float scale = (float)this.field_22787.method_22683().method_4495();
            MyRenderHelper.drawFramebuffer((class_276)frameBuffer, (boolean)true, (boolean)false, (float)((float)(left + 9) * scale), (double)((float)(left + 256 - 9) * scale), (float)((float)(top + 9) * scale), (double)((float)(top + 154 - 9) * scale));
            context.method_25302(OVERLAY, left, top, 0, 0, 256, 154);
        }

        public boolean method_25421() {
            return false;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (super.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.method_25419();
                return true;
            }
            return false;
        }
    }
}

