/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.compat.portal;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.compat.portal.PortalVisualizerUtil;
import dev.amble.ait.compat.portal.TardisPortal;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.EntityRef;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import dev.amble.lib.data.DirectedGlobalPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7718;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.render.PortalEntityRenderer;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalsHandler
extends KeyedTardisComponent {
    public static final TardisComponent.IdLike ID = new TardisComponent.AbstractId<PortalsHandler>("PORTALS", PortalsHandler::new, PortalsHandler.class);
    @Nullable
    private EntityRef<TardisPortal> interiorRef;
    @Nullable
    private EntityRef<TardisPortal> exteriorRef;

    public PortalsHandler() {
        super(ID);
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        if (this.isClient() || ctx.created()) {
            return;
        }
        if (this.exteriorRef != null) {
            class_3218 exteriorWorld = this.tardis.travel().position().getWorld();
            this.exteriorRef.setWorld(exteriorWorld);
        }
        if (this.interiorRef != null) {
            TardisServerWorld interiorWorld = this.tardis.asServer().world();
            this.interiorRef.setWorld((class_3218)interiorWorld);
        }
    }

    public static void init() {
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)AITMod.id("ip_portal"), TardisPortal.ENTITY_TYPE);
        if (!AITMod.CONFIG.allowPortalsBoti) {
            return;
        }
        TardisComponentRegistry.getInstance().register(ID);
        TardisEvents.DOOR_OPEN.register(tdis -> {
            PortalsHandler handler = (PortalsHandler)tdis.handler(ID);
            handler.generatePortals();
        });
        TardisEvents.REAL_DOOR_CLOSE.register(tdis -> {
            PortalsHandler handler = (PortalsHandler)tdis.handler(ID);
            handler.removePortals();
        });
        TardisEvents.DOOR_MOVE.register((tdis, newPos, oldPos) -> {
            PortalsHandler handler = (PortalsHandler)tdis.handler(ID);
            handler.removePortals();
            if (tdis.door().isOpen()) {
                handler.generatePortals();
            }
        });
        TardisEvents.EXTERIOR_CHANGE.register(tdis -> {
            PortalsHandler handler = (PortalsHandler)tdis.handler(ID);
            handler.removePortals();
            if (tdis.door().isOpen()) {
                handler.generatePortals();
            }
        });
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
            class_2596 dimSyncPacket = MiscNetworking.createDimSyncPacket();
            serverPlayNetworkHandler.method_14364(dimSyncPacket);
        });
        PortalVisualizerUtil.init();
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientInit() {
        PortalVisualizerUtil.clientInit();
        if (TardisPortal.ENTITY_TYPE != null) {
            EntityRendererRegistry.register(TardisPortal.ENTITY_TYPE, PortalEntityRenderer::new);
        }
    }

    public TardisPortal getInterior() {
        return this.interiorRef != null ? this.interiorRef.get() : null;
    }

    public TardisPortal getExterior() {
        return this.exteriorRef != null ? this.exteriorRef.get() : null;
    }

    private void generatePortals() {
        CachedDirectedGlobalPos exteriorPos = this.tardis().travel().position();
        DirectedBlockPos tempPos = this.tardis().getDesktop().getDoorPos();
        CachedDirectedGlobalPos interiorPos = CachedDirectedGlobalPos.create((class_3218)this.tardis().asServer().world(), tempPos.getPos(), tempPos.getRotation());
        this.removePortals();
        if (!this.tardis.getExterior().getVariant().hasPortals()) {
            return;
        }
        this.exteriorRef = new EntityRef<TardisPortal>(exteriorPos.getWorld(), this.createExteriorPortal());
        this.interiorRef = new EntityRef<TardisPortal>(interiorPos.getWorld(), this.createInteriorPortal());
    }

    private TardisPortal createExteriorPortal() {
        DirectedBlockPos doorPos = this.tardis.getDesktop().getDoorPos();
        CachedDirectedGlobalPos exteriorPos = this.tardis.travel().getState() == TravelHandlerBase.State.LANDED ? this.tardis.travel().position() : this.tardis.travel().getProgress();
        class_243 doorAdjust = PortalsHandler.adjustInteriorPos(this.tardis.getExterior().getVariant().door(), doorPos);
        class_243 exteriorAdjust = PortalsHandler.adjustExteriorPos(this.tardis.getExterior().getVariant(), exteriorPos);
        TardisPortal portal = new TardisPortal((class_1937)(this.tardis.travel().getState() == TravelHandlerBase.State.FLIGHT ? WorldUtil.getTimeVortex() : exteriorPos.getWorld()));
        portal.setOrientationAndSize(new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), this.tardis.getExterior().getVariant().portalWidth(), this.tardis.getExterior().getVariant().portalHeight());
        DQuaternion quat = DQuaternion.rotationByDegrees((class_243)new class_243(0.0, -1.0, 0.0), (double)(180.0f + class_7718.method_45482((int)exteriorPos.getRotation())));
        DQuaternion doorQuat = DQuaternion.rotationByDegrees((class_243)new class_243(0.0, -1.0, 0.0), (double)class_7718.method_45482((int)doorPos.getRotation()));
        PortalAPI.setPortalOrientationQuaternion((Portal)portal, (DQuaternion)quat);
        portal.setOtherSideOrientation(doorQuat);
        portal.setOriginPos(exteriorAdjust);
        portal.setDestinationDimension(this.tardis.asServer().world().method_27983());
        portal.setDestination(doorAdjust);
        portal.setInteractable(false);
        portal.method_37908().method_8649((class_1297)portal);
        return portal;
    }

    private TardisPortal createInteriorPortal() {
        DirectedBlockPos doorPos = this.tardis.getDesktop().getDoorPos();
        CachedDirectedGlobalPos exteriorPos = this.tardis.travel().getState() == TravelHandlerBase.State.LANDED ? this.tardis.travel().position() : this.tardis.travel().getProgress();
        class_243 doorAdjust = PortalsHandler.adjustInteriorPos(this.tardis.getExterior().getVariant().door(), doorPos);
        class_243 exteriorAdjust = PortalsHandler.adjustExteriorPos(this.tardis.getExterior().getVariant(), exteriorPos);
        TardisPortal portal = new TardisPortal((class_1937)this.tardis.asServer().world());
        portal.setOrientationAndSize(new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), this.tardis.getExterior().getVariant().portalWidth(), this.tardis.getExterior().getVariant().portalHeight());
        DQuaternion quat = DQuaternion.rotationByDegrees((class_243)new class_243(0.0, -1.0, 0.0), (double)class_7718.method_45482((int)doorPos.getRotation()));
        DQuaternion extQuat = DQuaternion.rotationByDegrees((class_243)new class_243(0.0, -1.0, 0.0), (double)(180.0f + class_7718.method_45482((int)exteriorPos.getRotation())));
        PortalAPI.setPortalOrientationQuaternion((Portal)portal, (DQuaternion)quat);
        portal.setOtherSideOrientation(extQuat);
        portal.setOriginPos(doorAdjust);
        portal.setDestinationDimension(this.tardis.travel().getState() == TravelHandlerBase.State.FLIGHT ? AITDimensions.TIME_VORTEX_WORLD : exteriorPos.getWorld().method_27983());
        portal.setDestination(exteriorAdjust);
        portal.setInteractable(false);
        portal.method_37908().method_8649((class_1297)portal);
        return portal;
    }

    private static class_243 adjustExteriorPos(ExteriorVariantSchema exterior, DirectedGlobalPos directed) {
        return exterior.getPortalPosition(directed.getPos().method_46558(), directed.getRotationDegrees()).method_1031(0.0, 0.75, 0.0);
    }

    private static class_243 adjustInteriorPos(DoorSchema door, DirectedBlockPos directed) {
        return door.getPortalPosition(directed.getPos().method_46558(), class_7718.method_45482((int)directed.getRotation())).method_1031(0.0, (double)0.55f, 0.0);
    }

    private void removePortals() {
        PortalsHandler.removePortal(this.getInterior());
        PortalsHandler.removePortal(this.getExterior());
    }

    private static void removePortal(Portal portal) {
        if (portal == null) {
            return;
        }
        PortalManipulation.removeConnectedPortals((Portal)portal, p -> {});
        portal.method_31472();
    }
}

