/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.api.ArtronHolder;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.item.ArtronCollectorItem;
import dev.amble.ait.core.item.ChargedZeitonCrystalItem;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.module.gun.core.item.StaserBoltMagazine;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class ArtronCollectorBlockEntity
extends class_2586
implements class_5558<ArtronCollectorBlockEntity>,
ArtronHolder {
    public double artronAmount = 0.0;

    public ArtronCollectorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.ARTRON_COLLECTOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("artronAmount", this.artronAmount);
    }

    public void method_11014(class_2487 nbt) {
        if (nbt.method_10545("artronAmount")) {
            this.setCurrentFuel(nbt.method_10574("artronAmount"));
        }
        super.method_11014(nbt);
    }

    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (!world.method_8608()) {
            player.method_43496((class_2561)class_2561.method_43470((String)(this.getCurrentFuel() + "/" + ArtronCollectorItem.COLLECTOR_MAX_FUEL)).method_27692(class_124.field_1065));
            class_1799 stack = player.method_6047();
            if (stack.method_7909() instanceof ArtronCollectorItem) {
                double residual = ArtronCollectorItem.addFuel(stack, this.getCurrentFuel());
                this.setCurrentFuel(residual);
            } else if (stack.method_7909() instanceof ArtronHolderItem) {
                double residual = ((ArtronHolderItem)stack.method_7909()).addFuel(this.getCurrentFuel(), stack);
                this.setCurrentFuel(residual);
            } else {
                class_1792 residual = stack.method_7909();
                if (residual instanceof ChargedZeitonCrystalItem) {
                    ChargedZeitonCrystalItem crystal = (ChargedZeitonCrystalItem)residual;
                    double residual2 = crystal.addFuel(this.getCurrentFuel(), stack);
                    this.setCurrentFuel(residual2);
                } else {
                    residual = stack.method_7909();
                    if (residual instanceof StaserBoltMagazine) {
                        StaserBoltMagazine magazine = (StaserBoltMagazine)residual;
                        double residual3 = magazine.addFuel(this.getCurrentFuel(), stack);
                        this.setCurrentFuel(residual3);
                    }
                }
            }
            if (stack.method_31574(AITBlocks.ZEITON_CLUSTER.method_8389())) {
                if (sneaking) {
                    player.method_31548().method_5447(player.method_31548().field_7545, new class_1799((class_1935)AITItems.CHARGED_ZEITON_CRYSTAL));
                    return;
                }
                this.addFuel(15.0);
                stack.method_7934(1);
            }
        }
    }

    @Override
    public void setCurrentFuel(double artronAmount) {
        this.artronAmount = artronAmount;
        this.updateListeners(this.method_11010());
    }

    @Override
    public double getMaxFuel() {
        return ArtronCollectorItem.COLLECTOR_MAX_FUEL.intValue();
    }

    @Override
    public double getCurrentFuel() {
        return this.artronAmount;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = super.method_16887();
        nbtCompound.method_10549("artronAmount", this.artronAmount);
        return nbtCompound;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, ArtronCollectorBlockEntity blockEntity) {
        class_1923 chunk;
        if (world.method_8608()) {
            return;
        }
        if (world.method_8503().method_3780() % 3 == 0) {
            return;
        }
        RiftChunkManager manager = RiftChunkManager.getInstance((class_3218)this.field_11863);
        if (this.shouldDrain(manager, chunk = new class_1923(pos))) {
            manager.removeFuel(chunk, 3.0);
            this.addFuel(3.0);
            this.updateListeners(state);
        }
    }

    private boolean shouldDrain(RiftChunkManager manager, class_1923 pos) {
        return this.getCurrentFuel() < (double)ArtronCollectorItem.COLLECTOR_MAX_FUEL.intValue() && manager.getArtron(pos) >= 3.0;
    }

    private void updateListeners(class_2680 state) {
        this.method_5431();
        if (!this.method_11002()) {
            return;
        }
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), state, 3);
    }
}

