/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.blockentities.AbstractConsoleBlockEntity;
import dev.amble.ait.core.entities.ConsoleControlEntity;
import dev.amble.ait.core.item.ChargedZeitonCrystalItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.ControlTypes;
import dev.amble.ait.core.tardis.control.sequences.SequenceHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import net.minecraft.class_5743;
import net.minecraft.class_7094;
import org.joml.Vector3f;

public class ConsoleBlockEntity
extends AbstractConsoleBlockEntity
implements class_5558<ConsoleBlockEntity>,
ArtronHolderItem {
    private class_1799 sonicScrewdriver = class_1799.field_8037;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    public final List<ConsoleControlEntity> controlEntities = new ArrayList<ConsoleControlEntity>();
    public final class_7094 ANIM_STATE = new class_7094();
    private boolean needsControls = true;
    private ConsoleTypeSchema type;
    private ConsoleVariantSchema variant;
    public int age;

    public ConsoleBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.CONSOLE_BLOCK_ENTITY_TYPE, pos, state);
    }

    @Override
    public void onLinked() {
        if (this.method_10997() == null || !TardisServerWorld.isTardisDimension(this.method_10997())) {
            return;
        }
        if (this.tardis().isEmpty()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        if (tardis instanceof ClientTardis) {
            return;
        }
        tardis.getDesktop().getConsolePos().add(this.field_11867);
        tardis.asServer().markDirty(tardis.getDesktop());
        this.markNeedsControl();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("type", this.getTypeSchema().id().toString());
        nbt.method_10582("variant", this.getVariant().id().toString());
        class_1262.method_5426((class_2487)nbt, this.inventory);
        if (this.sonicScrewdriver != null) {
            nbt.method_10566("sonic_screwdriver", (class_2520)this.sonicScrewdriver.method_7953(new class_2487()));
        }
    }

    @Override
    protected class_2561 getContainerName() {
        return class_2561.method_43471((String)(this.tardis().isPresent() ? this.tardis().get().stats().getName() : "ait.console.inventory"));
    }

    @Override
    protected class_1703 createScreenHandler(int syncId, class_1661 playerInventory) {
        return class_1707.method_19247((int)syncId, (class_1661)playerInventory, (class_1263)this);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.setType((ConsoleTypeSchema)ConsoleRegistry.getInstance().get(class_2960.method_12829((String)nbt.method_10558("type"))));
        this.setVariant((ConsoleVariantSchema)ConsoleVariantRegistry.getInstance().get(class_2960.method_12829((String)nbt.method_10558("variant"))));
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        if (nbt.method_10545("sonic_screwdriver")) {
            this.sonicScrewdriver = class_1799.method_7915((class_2487)nbt.method_10562("sonic_screwdriver"));
        }
    }

    @Override
    public class_2487 method_16887() {
        if (this.field_11863.method_27983().equals(class_1937.field_25179)) {
            return super.method_16887();
        }
        this.markNeedsControl();
        return super.method_16887();
    }

    public ConsoleTypeSchema getTypeSchema() {
        if (this.type == null) {
            this.setType(ConsoleRegistry.HARTNELL);
        }
        return this.type;
    }

    public void setType(ConsoleTypeSchema schema) {
        this.type = schema;
        this.method_5431();
    }

    public void setVariant(ConsoleVariantSchema schema) {
        this.variant = schema;
        this.method_5431();
    }

    public ConsoleVariantSchema getVariant() {
        if (this.variant == null) {
            this.setVariant(this.getTypeSchema().getDefaultVariant());
        }
        return this.variant;
    }

    public int getAge() {
        return this.age;
    }

    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        if (this.tardis().isEmpty()) {
            return;
        }
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7909() == AITBlocks.ZEITON_CLUSTER.method_8389()) {
            this.tardis().get().addFuel(15.0);
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            return;
        }
        if (itemStack.method_7909() instanceof ChargedZeitonCrystalItem) {
            class_2487 nbt = itemStack.method_7948();
            if (!nbt.method_10545("fuel")) {
                return;
            }
            this.tardis().get().addFuel(nbt.method_10574("fuel"));
            nbt.method_10549("fuel", 0.0);
        }
    }

    @Override
    public void method_11012() {
        this.killControls();
        super.method_11012();
    }

    public void onBroken() {
        this.killControls();
        if (this.tardis().isEmpty()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        TardisDesktop desktop = tardis.getDesktop();
        desktop.getConsolePos().remove(this.field_11867);
        tardis.asServer().markDirty(desktop);
    }

    public void killControls() {
        this.controlEntities.forEach(class_1297::method_31472);
        this.controlEntities.clear();
    }

    public void spawnControls() {
        ControlTypes[] controls;
        class_2338 current = this.method_11016();
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (!TardisServerWorld.isTardisDimension((class_3218)this.method_10997())) {
            return;
        }
        this.killControls();
        ConsoleTypeSchema consoleType = this.getTypeSchema();
        for (ControlTypes control : controls = consoleType.getControlTypes()) {
            ConsoleControlEntity controlEntity = ConsoleControlEntity.create(this.field_11863, this.tardis().get());
            Vector3f position = current.method_46558().method_46409().add(control.getOffset().x(), control.getOffset().y(), control.getOffset().z());
            controlEntity.method_5814(position.x(), position.y(), position.z());
            controlEntity.method_36456(0.0f);
            controlEntity.method_36457(0.0f);
            controlEntity.setControlData(consoleType, control, this.method_11016());
            serverWorld.method_8649((class_1297)controlEntity);
            this.controlEntities.add(controlEntity);
        }
        this.needsControls = false;
    }

    public void markNeedsControl() {
        this.needsControls = true;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, ConsoleBlockEntity blockEntity) {
        boolean moreThanAFew;
        if (!TardisServerWorld.isTardisDimension(world)) {
            return;
        }
        if (this.needsControls) {
            this.spawnControls();
        }
        if (!(world instanceof class_3218)) {
            ++this.age;
            this.ANIM_STATE.method_41324(this.age);
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (!TardisServerWorld.isTardisDimension((class_3218)this.method_10997())) {
            this.method_11012();
        }
        if (!this.isLinked()) {
            return;
        }
        SequenceHandler handler = this.tardis().get().sequence();
        TravelHandlerBase.State travelState = this.tardis().get().travel().getState();
        if (travelState == TravelHandlerBase.State.FLIGHT || travelState == TravelHandlerBase.State.MAT) {
            if (handler.hasActiveSequence() && handler.getActiveSequence() != null) {
                List<Control> sequence = handler.getActiveSequence().getControls();
                this.controlEntities.forEach(entity -> {
                    int index = sequence.indexOf(entity.getControl());
                    Control control = entity.getControl();
                    entity.setPartOfSequence(index != -1);
                    entity.setWasSequenced(handler.doesControlIndexMatch(control));
                    entity.setSequenceIndex(index);
                    entity.setSequenceLength(sequence.size());
                });
            } else {
                this.controlEntities.forEach(entity -> entity.setPartOfSequence(false));
            }
        }
        world.method_8452(pos, state.method_26204());
        ServerTardis tardis = (ServerTardis)this.tardis().get();
        boolean isRiftChunk = RiftChunkManager.isRiftChunk(tardis.travel().position());
        boolean bl = moreThanAFew = this.controlEntities.stream().filter(controlEntity -> controlEntity.getDurability() < ConsoleControlEntity.DurabilityStates.FULL.durability).count() > 5L;
        if (tardis.travel().isCrashing() || moreThanAFew) {
            serverWorld.method_14199((class_2394)class_2398.field_11237, (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.25, (double)((float)pos.method_10260() + 0.5f), 5, 0.0, 0.0, 0.0, (double)0.025f);
            serverWorld.method_14199((class_2394)class_2398.field_22246, (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.85, (double)((float)pos.method_10260() + 0.5f), 2, (double)0.2f, 0.5, (double)0.2f, (double)0.01f);
            serverWorld.method_14199((class_2394)new class_5743(new Vector3f(0.75f, 0.75f, 0.75f), new Vector3f(0.1f, 0.1f, 0.1f), 1.0f), (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.25, (double)((float)pos.method_10260() + 0.5f), 1, 0.0, 0.0, 0.0, (double)0.01f);
        }
        if (tardis.crash().isToxic() || tardis.crash().isUnstable()) {
            serverWorld.method_14199((class_2394)class_2398.field_11237, (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.25, (double)((float)pos.method_10260() + 0.5f), 5, 0.0, 0.0, 0.0, (double)0.025f);
            serverWorld.method_14199((class_2394)class_2398.field_11204, (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.25, (double)((float)pos.method_10260() + 0.5f), 1, 0.0, (double)0.05f, 0.0, (double)0.025f);
        }
        if (tardis.crash().isToxic()) {
            serverWorld.method_14199((class_2394)new class_5743(new Vector3f(0.75f, 0.85f, 0.75f), new Vector3f(0.15f, 0.25f, 0.15f), 1.0f), (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.25, (double)((float)pos.method_10260() + 0.5f), 1, AITMod.RANDOM.nextBoolean() ? 0.5 : -0.5, 3.0, AITMod.RANDOM.nextBoolean() ? 0.5 : -0.5, (double)0.025f);
        }
        if (tardis.isRefueling() && tardis.getFuel() < 50000.0) {
            serverWorld.method_14199((class_2394)(isRiftChunk ? class_2398.field_11248 : class_2398.field_11207), (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264() + 1.25, (double)((float)pos.method_10260() + 0.5f), 1, 0.0, 0.0, 0.0, isRiftChunk ? (double)0.05f : (double)0.025f);
        }
        if (ServerLifecycleHooks.get().method_3780() % 10 != 0) {
            return;
        }
        if (this.sonicScrewdriver != null) {
            if (this.hasMaxFuel(this.sonicScrewdriver)) {
                return;
            }
            if (!tardis.fuel().hasPower()) {
                return;
            }
            this.addFuel(10.0, this.sonicScrewdriver);
            tardis.fuel().removeFuel(10.0);
        }
    }

    public static ConsoleTypeSchema previousConsole(ConsoleTypeSchema current) {
        List list = ConsoleRegistry.getInstance().toList();
        int idx = list.indexOf(current);
        int size = list.size();
        return (ConsoleTypeSchema)list.get((size + idx - 1) % size);
    }

    public static ConsoleTypeSchema nextConsole(ConsoleTypeSchema current) {
        List list = ConsoleRegistry.getInstance().toList();
        int idx = list.indexOf(current);
        int size = list.size();
        return (ConsoleTypeSchema)list.get((idx + 1) % size);
    }

    public static ConsoleVariantSchema previousVariant(ConsoleVariantSchema current) {
        List<ConsoleVariantSchema> list = ConsoleVariantRegistry.withParent(current.parent());
        int idx = list.indexOf(current);
        int size = list.size();
        return list.get((size + idx - 1) % size);
    }

    public static ConsoleVariantSchema nextVariant(ConsoleVariantSchema current) {
        List<ConsoleVariantSchema> list = ConsoleVariantRegistry.withParent(current.parent());
        int idx = list.indexOf(current);
        int size = list.size();
        return list.get((idx + 1) % size);
    }

    public int method_5439() {
        return this.getInventory().size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.getInventory()) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.getInventory(), (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return (class_1799)this.getInventory().remove(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.getInventory().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        return false;
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player) && !this.method_5442();
    }

    public void method_5448() {
        this.getInventory().clear();
    }

    public void setSonicScrewdriver(class_1799 stack) {
        this.sonicScrewdriver = stack;
        this.sync();
        this.method_5431();
    }

    public class_1799 getSonicScrewdriver() {
        return this.sonicScrewdriver;
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return 1000.0;
    }
}

