/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.engine.link.block.FluidLinkBlockEntity;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ConsoleGeneratorBlockEntity
extends FluidLinkBlockEntity {
    public static final class_2960 SYNC_TYPE = AITMod.id("sync_gen_type");
    public static final class_2960 SYNC_VARIANT = AITMod.id("sync_gen_variant");
    private class_2960 type;
    private class_2960 variant;

    public ConsoleGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.CONSOLE_GENERATOR_ENTITY_TYPE, pos, state);
        this.type = ConsoleRegistry.HARTNELL.id();
    }

    public ConsoleGeneratorBlockEntity(class_2338 pos, class_2680 state, class_2960 type, class_2960 variant) {
        super(AITBlockEntityTypes.CONSOLE_GENERATOR_ENTITY_TYPE, pos, state);
        this.type = type;
        this.variant = variant;
    }

    public void useOn(class_1937 world, boolean sneaking, boolean punching, class_1657 player) {
        if (!TardisServerWorld.isTardisDimension(world)) {
            return;
        }
        if (!this.isLinked()) {
            return;
        }
        class_1799 stack = player.method_6047();
        boolean validItem = stack.method_31574(AITItems.SONIC_SCREWDRIVER) || stack.method_31574(class_1802.field_8183);
        boolean decrement = stack.method_31574(class_1802.field_8183);
        if (validItem && this.tardis().get().isUnlocked(this.getConsoleVariant())) {
            if (decrement) {
                stack.method_7934(1);
            }
            this.createConsole(player);
            return;
        }
        world.method_8396(null, this.field_11867, class_3417.field_37358, class_3419.field_15245, 0.5f, 1.0f);
        if (sneaking) {
            this.changeConsole(punching ? ConsoleBlockEntity.previousVariant(this.getConsoleVariant()) : ConsoleBlockEntity.nextVariant(this.getConsoleVariant()));
        } else {
            this.changeConsole(punching ? ConsoleBlockEntity.previousConsole(this.getConsoleSchema()) : ConsoleBlockEntity.nextConsole(this.getConsoleSchema()));
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.type != null) {
            nbt.method_10582("console", this.type.toString());
        }
        if (this.variant != null) {
            nbt.method_10582("variant", this.variant.toString());
        }
    }

    private void createConsole(class_1657 player) {
        if (this.method_10997() != null && this.method_10997().method_8608()) {
            return;
        }
        ConsoleBlockEntity be = new ConsoleBlockEntity(this.field_11867, AITBlocks.CONSOLE.method_9564());
        be.setType(this.getConsoleSchema());
        be.setVariant(this.getConsoleVariant());
        if (this.field_11863 == null) {
            return;
        }
        if (this.tardis().isPresent() && !this.tardis().get().isUnlocked(this.getConsoleVariant())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"This console is not unlocked yet!").method_27692(class_124.field_1056), true);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_29189, class_3419.field_15245, 0.5f, 1.0f);
            return;
        }
        this.field_11863.method_8501(this.field_11867, AITBlocks.CONSOLE.method_9564());
        this.field_11863.method_8438((class_2586)be);
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14891, class_3419.field_15245, 0.5f, 1.0f);
    }

    public ConsoleTypeSchema getConsoleSchema() {
        if (this.type == null) {
            this.setConsoleSchema(ConsoleRegistry.HARTNELL.id());
        }
        return (ConsoleTypeSchema)ConsoleRegistry.getInstance().get(this.type);
    }

    public void setConsoleSchema(class_2960 type) {
        this.type = type;
        this.method_5431();
        this.syncType();
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public ConsoleVariantSchema getConsoleVariant() {
        if (this.variant == null) {
            this.variant = this.getConsoleSchema().getDefaultVariant().id();
        }
        return (ConsoleVariantSchema)ConsoleVariantRegistry.getInstance().get(this.variant);
    }

    public void setVariant(class_2960 variant) {
        this.variant = variant;
        this.method_5431();
        this.syncVariant();
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public void changeConsole(ConsoleTypeSchema schema) {
        this.setConsoleSchema(schema.id());
        this.setVariant(schema.getDefaultVariant().id());
    }

    public void changeConsole(ConsoleVariantSchema schema) {
        this.setConsoleSchema(schema.parent().id());
        this.setVariant(schema.id());
    }

    private void syncType() {
        if (!this.method_11002() || this.field_11863.method_8608()) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.getConsoleSchema().id().toString());
        buf.method_10807(this.method_11016());
        for (class_1657 player : this.field_11863.method_18456()) {
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)SYNC_TYPE, (class_2540)buf);
        }
    }

    private void syncVariant() {
        if (!this.method_11002() || this.field_11863.method_8608()) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.getConsoleVariant().id().toString());
        buf.method_10807(this.method_11016());
        for (class_1657 player : this.field_11863.method_18456()) {
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)SYNC_VARIANT, (class_2540)buf);
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        if (nbt.method_10545("console")) {
            class_2960 console = new class_2960(nbt.method_10558("console"));
            this.setConsoleSchema(console);
        }
        if (nbt.method_10545("variant")) {
            class_2960 variant = new class_2960(nbt.method_10558("variant"));
            this.setVariant(variant);
        }
        super.method_11014(nbt);
    }
}

