/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.blocks.DoorBlock;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.SonicHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_7718;
import org.jetbrains.annotations.Nullable;

public class DoorBlockEntity
extends InteriorLinkableBlockEntity {
    private DirectedBlockPos directedPos;

    public DoorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.DOOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 blockState, T tDoor) {
        DoorBlockEntity door = (DoorBlockEntity)tDoor;
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (!door.isLinked()) {
            return;
        }
        Tardis tardis = door.tardis().get();
        if (world.method_8503().method_3780() % 5 != 0) {
            return;
        }
        CachedDirectedGlobalPos globalExteriorPos = tardis.travel().position();
        if (globalExteriorPos == null) {
            return;
        }
        class_2338 exteriorPos = globalExteriorPos.getPos();
        class_3218 exteriorWorld = globalExteriorPos.getWorld();
        if (exteriorWorld == null) {
            return;
        }
        blockState = (class_2680)blockState.method_11657((class_2769)DoorBlock.LEVEL_4, (Comparable)Integer.valueOf(exteriorWorld.method_22339(exteriorPos.method_10084())));
        if (world.method_8503().method_3780() % 20 != 0) {
            world.method_8652(pos, blockState, 11);
            return;
        }
        if (!tardis.door().isOpen() || tardis.areShieldsActive()) {
            world.method_8652(pos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 11);
            return;
        }
        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue() && world.method_8409().method_43056()) {
            serverWorld.method_18456().forEach(player -> tardis.loyalty().subLevel((class_3222)player, 2));
        }
        class_1923 exteriorChunkPos = new class_1923(exteriorPos);
        class_2791 exteriorChunk = exteriorWorld.method_8402(exteriorChunkPos.field_9181, exteriorChunkPos.field_9180, class_2806.field_12798, false);
        if (exteriorChunk == null) {
            return;
        }
        class_2680 exteriorState = exteriorChunk.method_8320(exteriorPos);
        if (!(exteriorState.method_26204() instanceof ExteriorBlock)) {
            return;
        }
        boolean waterlogged = (Boolean)exteriorWorld.method_8320(exteriorPos).method_11654((class_2769)class_2741.field_12508);
        world.method_8652(pos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged)), 11);
        world.method_33596(null, class_5712.field_28733, pos);
        world.method_39281(pos, blockState.method_26227().method_15772(), blockState.method_26227().method_15772().method_15789((class_4538)world));
    }

    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (player == null || this.tardis() == null || this.tardis().isEmpty()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        class_1799 keyStack = player.method_6047();
        if (tardis.hasGrowthExterior()) {
            return;
        }
        tardis.getDesktop().setDoorPos(this);
        class_1792 class_17922 = keyStack.method_7909();
        if (class_17922 instanceof KeyItem) {
            KeyItem key = (KeyItem)class_17922;
            if (!tardis.siege().isActive()) {
                if (keyStack.method_31574(AITItems.SKELETON_KEY) || key.isOf(keyStack, tardis)) {
                    tardis.door().interactToggleLock((class_3222)player);
                } else {
                    world.method_8396(null, this.field_11867, (class_3414)class_3417.field_18311.comp_349(), class_3419.field_15245, 1.0f, 0.2f);
                    player.method_7353((class_2561)class_2561.method_43471((String)"tardis.key.identity_error"), true);
                }
                return;
            }
        }
        if (tardis.sonic().getExteriorSonic() != null) {
            SonicHandler handler = tardis.sonic();
            if (this.field_11867 != null) {
                player.method_31548().method_7398(handler.takeExteriorSonic());
                world.method_8396(null, this.field_11867, (class_3414)class_3417.field_23117.comp_349(), class_3419.field_15245, 1.0f, 0.2f);
            }
            return;
        }
        tardis.door().interact((class_3218)world, this.method_11016(), (class_3222)player);
    }

    public class_2350 getFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)HorizontalDirectionalBlock.FACING);
    }

    @Override
    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void onEntityCollision(class_1297 entity) {
        if (!TardisServerWorld.isTardisDimension((class_3218)this.method_10997())) {
            return;
        }
        if (!this.isLinked()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        if (tardis.door().isClosed()) {
            return;
        }
        if (DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti && tardis.getExterior().getVariant().hasPortals()) {
            return;
        }
        TravelHandler travel = tardis.travel();
        if (!tardis.flight().isFlying() && travel.getState() == TravelHandlerBase.State.FLIGHT && !tardis.areShieldsActive()) {
            TardisUtil.dropOutside(tardis, entity);
            return;
        }
        if (travel.getState() != TravelHandlerBase.State.LANDED) {
            return;
        }
        TardisUtil.teleportOutside(tardis, entity);
    }

    @Override
    public void onLinked() {
        this.tardis().ifPresent(tardis -> tardis.getDesktop().setDoorPos(this));
    }

    public void onBreak() {
        if (!this.isLinked()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        tardis.door().closeDoors();
        tardis.getDesktop().removeDoor(this);
    }

    public DirectedBlockPos getDirectedPos() {
        if (this.directedPos != null) {
            return this.directedPos;
        }
        this.directedPos = DirectedBlockPos.create((class_2338)this.method_11016(), (byte)((byte)class_7718.method_45481((class_2350)this.getFacing())));
        return this.directedPos;
    }
}

