/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.SubSystemBlockEntity;
import dev.amble.ait.core.engine.link.IFluidLink;
import dev.amble.ait.core.engine.link.IFluidSource;
import dev.amble.ait.core.engine.link.ITardisSource;
import dev.amble.ait.core.tardis.Tardis;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class EngineBlockEntity
extends SubSystemBlockEntity
implements ITardisSource {
    public EngineBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.ENGINE_BLOCK_ENTITY_TYPE, pos, state, SubSystem.Id.ENGINE);
        if (!this.method_11002()) {
            return;
        }
    }

    @Override
    public void onPlaced(class_1937 world, class_2338 pos, @Nullable class_1309 placer) {
        super.onPlaced(world, pos, placer);
        if (world.method_8608()) {
            return;
        }
        this.tardis().ifPresent(tardis -> tardis.subsystems().engine().setEnabled(true));
        if (this.tryPlaceFillBlocks()) {
            return;
        }
        this.onBroken(world, pos);
        world.method_8501(pos, class_2246.field_10124.method_9564());
        if (placer == null) {
            return;
        }
        class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)AITBlocks.ENGINE_BLOCK.method_8389().method_7854());
        if (!(placer instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)placer;
        player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.engine.no_space").method_27692(class_124.field_1061), true);
    }

    @Override
    public void onBroken(class_1937 world, class_2338 pos) {
        this.onLoseFluid();
        this.tryRemoveFillBlocks();
        super.onBroken(world, pos);
    }

    private boolean tryPlaceFillBlocks() {
        if (this.method_10997().method_8608()) {
            return false;
        }
        boolean success = true;
        class_2338 centre = this.method_11016();
        class_3218 world = (class_3218)this.method_10997();
        for (class_2350 dir : class_2350.values()) {
            if (dir == class_2350.field_11036 || dir == class_2350.field_11033) continue;
            class_2338 offset = centre.method_10093(dir);
            success = success && this.tryPlace(world, offset, AITBlocks.CABLE_BLOCK.method_9564());
        }
        class_2338 corner = centre.method_10069(1, 0, 1);
        success = success && this.tryPlace(world, corner, class_2246.field_10499.method_9564());
        corner = centre.method_10069(-1, 0, 1);
        success = success && this.tryPlace(world, corner, class_2246.field_10499.method_9564());
        corner = centre.method_10069(1, 0, -1);
        success = success && this.tryPlace(world, corner, class_2246.field_10499.method_9564());
        corner = centre.method_10069(-1, 0, -1);
        success = success && this.tryPlace(world, corner, class_2246.field_10499.method_9564());
        return success;
    }

    private boolean tryPlace(class_3218 world, class_2338 pos, class_2680 state) {
        if (world.method_8320(pos).method_45474()) {
            world.method_8501(pos, state);
            return true;
        }
        return false;
    }

    private void tryRemoveFillBlocks() {
        if (this.method_10997().method_8608()) {
            return;
        }
        class_2338 centre = this.method_11016();
        class_3218 world = (class_3218)this.method_10997();
        for (class_2350 dir : class_2350.values()) {
            class_2338 offset = centre.method_10093(dir);
            this.tryRemoveIfMatches(world, offset, AITBlocks.CABLE_BLOCK);
        }
        class_2338 corner = centre.method_10069(1, 0, 1);
        this.tryRemoveIfMatches(world, corner, class_2246.field_10499);
        corner = centre.method_10069(-1, 0, 1);
        this.tryRemoveIfMatches(world, corner, class_2246.field_10499);
        corner = centre.method_10069(1, 0, -1);
        this.tryRemoveIfMatches(world, corner, class_2246.field_10499);
        corner = centre.method_10069(-1, 0, -1);
        this.tryRemoveIfMatches(world, corner, class_2246.field_10499);
    }

    private void tryRemoveIfMatches(class_3218 world, class_2338 pos, class_2248 expected) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852(expected)) {
            return;
        }
        world.method_8650(pos, false);
    }

    @Override
    public void onLinked() {
        this.tardis().ifPresent(tardis -> tardis.getDesktop().setEnginePos(this));
    }

    @Override
    public Tardis getTardisForFluid() {
        return this.tardis().get();
    }

    @Override
    public void setSource(IFluidSource source) {
    }

    @Override
    public void setLast(IFluidLink last) {
    }

    @Override
    public IFluidSource source(boolean search) {
        return this;
    }

    @Override
    public IFluidLink last() {
        return this;
    }

    @Override
    public class_2338 getLastPos() {
        return this.method_11016();
    }
}

