/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.blocks.EnvironmentProjectorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.properties.Value;
import java.util.Iterator;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class EnvironmentProjectorBlockEntity
extends InteriorLinkableBlockEntity {
    private static final class_5321<class_1937> DEFAULT = class_1937.field_25181;
    private class_5321<class_1937> current = DEFAULT;

    public EnvironmentProjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.ENVIRONMENT_PROJECTOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        boolean powered = world.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)EnvironmentProjectorBlock.POWERED)) {
            if ((Boolean)state.method_11654((class_2769)EnvironmentProjectorBlock.ENABLED) != powered) {
                state = (class_2680)state.method_11657((class_2769)EnvironmentProjectorBlock.ENABLED, (Comparable)Boolean.valueOf(powered));
                EnvironmentProjectorBlock.toggle(this.tardis().get(), null, world, pos, state, powered);
            }
            state = (class_2680)state.method_11657((class_2769)EnvironmentProjectorBlock.POWERED, (Comparable)Boolean.valueOf(powered));
        }
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)EnvironmentProjectorBlock.SILENT, (Comparable)Boolean.valueOf(world.method_8320(pos.method_10074()).method_26164(class_3481.field_15481))), 2);
    }

    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!this.isLinked()) {
            return class_1269.field_5814;
        }
        Tardis tardis = this.tardis().get();
        if (player.method_5715()) {
            this.switchSkybox(tardis, state, player);
            return class_1269.field_5812;
        }
        state = (class_2680)state.method_28493((class_2769)EnvironmentProjectorBlock.ENABLED);
        world.method_8652(pos, state, 2);
        EnvironmentProjectorBlock.toggle(tardis, null, world, pos, state, (Boolean)state.method_11654((class_2769)EnvironmentProjectorBlock.ENABLED));
        return class_1269.field_5812;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.current = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(nbt.method_10558("dimension")));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("dimension", this.current.method_29177().toString());
    }

    public void switchSkybox(Tardis tardis, class_2680 state, class_1657 player) {
        class_3218 next = EnvironmentProjectorBlockEntity.findNext(this.current);
        while (TardisServerWorld.isTardisDimension(next)) {
            next = EnvironmentProjectorBlockEntity.findNext((class_5321<class_1937>)next.method_27983());
        }
        player.method_43496((class_2561)class_2561.method_43469((String)"message.ait.projector.skybox", (Object[])new Object[]{next.method_27983().method_29177().toString()}));
        AITMod.LOGGER.debug("Last: {}, next: {}", this.current, (Object)next);
        this.current = next.method_27983();
        if (((Boolean)state.method_11654((class_2769)EnvironmentProjectorBlock.ENABLED)).booleanValue()) {
            this.apply(tardis, state);
        }
    }

    public void toggle(Tardis tardis, class_2680 state, boolean active) {
        if (active) {
            this.apply(tardis, state);
        } else {
            this.disable(tardis);
        }
    }

    public void apply(Tardis tardis, class_2680 state) {
        tardis.stats().skybox().set(this.current);
        tardis.stats().skyboxDirection().set((class_2350)state.method_11654((class_2769)EnvironmentProjectorBlock.FACING));
    }

    public void disable(Tardis tardis) {
        Value<class_5321<class_1937>> value = tardis.stats().skybox();
        if (EnvironmentProjectorBlockEntity.same(this.current, value.get())) {
            value.set(DEFAULT);
        }
    }

    private static class_3218 findNext(class_5321<class_1937> last) {
        class_3218 first;
        Iterator<class_3218> iter = WorldUtil.getProjectorWorlds().iterator();
        class_3218 found = first = iter.next();
        while (iter.hasNext()) {
            if (EnvironmentProjectorBlockEntity.same((class_5321<class_1937>)found.method_27983(), last)) {
                if (!iter.hasNext()) break;
                return iter.next();
            }
            found = iter.next();
        }
        return first;
    }

    private static boolean same(class_5321<class_1937> a, class_5321<class_1937> b) {
        return a == b || a.method_29177().equals((Object)b.method_29177());
    }
}

