/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.item.SiegeTardisItem;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.SecurityControl;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.SonicHandler;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.category.AdaptiveCategory;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7718;
import net.minecraft.class_8162;

public class ExteriorBlockEntity
extends AbstractLinkableBlockEntity
implements class_5558<ExteriorBlockEntity> {
    private UUID seatEntityUUID = null;

    public ExteriorBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.EXTERIOR_BLOCK_ENTITY_TYPE, pos, state);
    }

    public ExteriorBlockEntity(class_2338 pos, class_2680 state, Tardis tardis) {
        this(pos, state);
        this.link(tardis);
    }

    public void useOn(class_3218 world, boolean sneaking, class_1657 player) {
        SonicItem sonic;
        if (this.tardis().isEmpty() || player == null) {
            return;
        }
        if (!this.validateExteriorPosition()) {
            return;
        }
        ServerTardis tardis = (ServerTardis)this.tardis().get();
        class_1799 hand = player.method_6047();
        if (tardis.isGrowth()) {
            if (tardis.interiorChanging().hasCage()) {
                int plasmic;
                if (hand.method_7909() == AITItems.PLASMIC_MATERIAL && (plasmic = tardis.interiorChanging().plasmicMaterialAmount()) < 8) {
                    tardis.interiorChanging().addPlasmicMaterial(1);
                    world.method_8396(null, this.field_11867, class_3417.field_14949, class_3419.field_15245, 1.0f, (float)plasmic / 8.0f);
                    hand.method_7934(1);
                }
            } else {
                if (hand.method_7909() == AITItems.CORAL_CAGE) {
                    world.method_8396(null, this.field_11867, class_3417.field_24062, class_3419.field_15245, 1.0f, 0.7f);
                    tardis.interiorChanging().setHasCage(true);
                    hand.method_7934(1);
                    return;
                }
                world.method_8396(null, this.field_11867, class_3417.field_14672, class_3419.field_15245, 1.0f, 0.3f);
                player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.growth.no_cage"), true);
            }
            return;
        }
        SonicHandler handler = tardis.sonic();
        boolean hasSonic = handler.getExteriorSonic() != null;
        boolean shouldEject = player.method_5715();
        if (hand.method_7909() instanceof class_8162 && ((BiomeHandler)tardis.handler(TardisComponent.Id.BIOME)).getBiomeKey() != BiomeHandler.BiomeType.DEFAULT) {
            ((BiomeHandler)tardis.handler(TardisComponent.Id.BIOME)).forceTypeDefault();
            return;
        }
        class_1792 class_17922 = hand.method_7909();
        if (class_17922 instanceof KeyItem) {
            KeyItem key = (KeyItem)class_17922;
            if (!tardis.siege().isActive() && !((Boolean)tardis.interiorChanging().queued().get()).booleanValue()) {
                if (hand.method_31574(AITItems.SKELETON_KEY) || key.isOf(hand, tardis)) {
                    tardis.door().interactToggleLock((class_3222)player);
                } else {
                    world.method_8396(null, this.field_11867, (class_3414)class_3417.field_18311.comp_349(), class_3419.field_15245, 1.0f, 0.2f);
                    player.method_7353((class_2561)class_2561.method_43471((String)"tardis.key.identity_error"), true);
                }
                return;
            }
        }
        if (hasSonic) {
            if (shouldEject) {
                player.method_31548().method_7398(handler.takeExteriorSonic());
                world.method_8396(null, this.field_11867, (class_3414)class_3417.field_23117.comp_349(), class_3419.field_15245, 1.0f, 0.2f);
                return;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"tardis.exterior.sonic.repairing").method_10852((class_2561)class_2561.method_43470((String)(": " + tardis.crash().getRepairTicksAsSeconds() + "s")).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065})), true);
            return;
        }
        class_17922 = hand.method_7909();
        if (class_17922 instanceof SonicItem && (sonic = (SonicItem)class_17922).isOf(hand, tardis)) {
            if (!tardis.siege().isActive() && !((Boolean)tardis.interiorChanging().queued().get()).booleanValue() && tardis.door().isClosed() && tardis.crash().getRepairTicks() > 0) {
                if (sonic.isOf(hand, tardis)) {
                    handler.insertExteriorSonic(hand);
                    player.method_6122(class_1268.field_5808, class_1799.field_8037);
                    tardis.alarm().disable();
                    world.method_8396(null, this.field_11867, AITSounds.SONIC_ON, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_8396(null, this.field_11867, AITSounds.SONIC_MENDING, class_3419.field_15245, 1.0f, 1.0f);
                    Scheduler.get().runTaskLater(() -> world.method_8396(null, this.field_11867, AITSounds.TARDIS_BLING, class_3419.field_15245, 1.0f, 1.0f), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 15L);
                } else {
                    world.method_8396(null, this.field_11867, (class_3414)class_3417.field_23117.comp_349(), class_3419.field_15245, 1.0f, 0.2f);
                    player.method_7353((class_2561)class_2561.method_43471((String)"tardis.tool.cannot_repair"), true);
                }
                return;
            }
            EngineSystem.Phaser phasing = tardis.subsystems().engine().phaser();
            if (phasing.isPhasing() && SonicItem.mode(hand) == SonicMode.Modes.TARDIS) {
                world.method_8396(null, this.field_11867, AITSounds.SONIC_USE, class_3419.field_15248, 1.0f, 1.0f);
                phasing.cancel();
                return;
            }
        }
        if (player.method_6079().method_7909() instanceof SonicItem && SonicItem.mode(player.method_6079()) == SonicMode.Modes.INTERACTION && tardis.getExterior().getCategory().id().equals((Object)AdaptiveCategory.REFERENCE) && tardis.door().isClosed() && !tardis.siege().isActive() && !((Boolean)tardis.interiorChanging().queued().get()).booleanValue() && tardis.crash().getState() == TardisCrashHandler.State.NORMAL) {
            boolean isPermitted;
            Loyalty playerLoyalty = tardis.loyalty().get(player);
            Loyalty pilotLoyalty = Loyalty.fromLevel(Loyalty.Type.PILOT.level);
            boolean bl = (Boolean)tardis.stats().security().get() != false ? SecurityControl.hasMatchingKey((class_3222)player, tardis) : (isPermitted = playerLoyalty.greaterOrEqual(pilotLoyalty) || player.method_5687(2));
            if (!isPermitted) {
                return;
            }
            tardis.chameleon().clearDisguise();
            tardis.chameleon().applyDisguise();
            return;
        }
        if (sneaking && !tardis.isSiegeBeingHeld() && tardis.siege().isActive()) {
            SiegeTardisItem.pickupTardis(tardis, (class_3222)player);
            return;
        }
        if (!tardis.travel().isLanded()) {
            return;
        }
        tardis.door().interact((class_3218)this.method_10997(), this.method_11016(), (class_3222)player);
    }

    @Deprecated(since="1.3.0")
    public boolean validateExteriorPosition() {
        if (!this.isLinked()) {
            return true;
        }
        ServerTardis tardis = this.tardis().get().asServer();
        CachedDirectedGlobalPos expectedPos = tardis.travel().position();
        class_2338 expectedBlockPos = expectedPos.getPos();
        class_3218 extWorld = (class_3218)this.method_10997();
        class_2338 extPos = this.method_11016();
        if (extPos.equals((Object)expectedBlockPos) && expectedPos.getWorld() == extWorld) {
            return true;
        }
        AITMod.LOGGER.warn("Invalid exterior at {} {}, expected {} {} for TARDIS {}. Removing..", new Object[]{extWorld.method_27983(), extPos, expectedPos.getDimension(), expectedBlockPos, tardis.getUuid()});
        extWorld.method_8501(extPos, class_2246.field_10124.method_9564());
        return true;
    }

    public void sitOn(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) {
            return;
        }
        ServerTardis tardis = this.tardis().get().asServer();
        ExteriorVariantSchema variant = tardis.getExterior().getVariant();
        float playerPitch = player.method_5695(1.0f);
        if (variant == null) {
            return;
        }
        if (playerPitch > 50.0f) {
            class_243 seatPos = new class_243(variant.seatTranslations().field_1352 + (double)pos.method_10263(), variant.seatTranslations().field_1351 + (double)pos.method_10264(), variant.seatTranslations().field_1350 + (double)pos.method_10260());
            byte rotation = tardis.travel().position().getRotation();
            float yaw = class_7718.method_45482((int)rotation) + 180.0f;
            class_243 adjustedPos = this.moveForward(seatPos, yaw, variant.seatForwardTranslation());
            this.summonSeatEntity(world, adjustedPos, player, yaw);
        }
    }

    private class_243 moveForward(class_243 pos, float yaw, double distance) {
        double radians = Math.toRadians(yaw);
        double offsetX = -Math.sin(radians) * distance;
        double offsetZ = Math.cos(radians) * distance;
        return pos.method_1031(offsetX, 0.0, offsetZ);
    }

    private void summonSeatEntity(class_1937 world, class_243 pos, class_1657 player, float yaw) {
        class_1531 seat = new class_1531(class_1299.field_6131, world);
        seat.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        seat.method_5648(true);
        seat.method_5875(true);
        seat.method_5684(true);
        seat.method_36456(yaw);
        world.method_8649((class_1297)seat);
        player.method_5873((class_1297)seat, true);
        this.setSeatEntity(seat.method_5667());
    }

    public void setSeatEntity(UUID seatUUID) {
        this.seatEntityUUID = seatUUID;
    }

    public class_1297 getSeatEntity(class_1937 world) {
        if (this.seatEntityUUID == null) {
            return null;
        }
        return ((class_3218)world).method_14190(this.seatEntityUUID);
    }

    public void onEntityCollision(class_1297 entity) {
        if (!this.validateExteriorPosition()) {
            return;
        }
        TardisRef ref = this.tardis();
        if (ref == null) {
            return;
        }
        if (ref.isEmpty()) {
            return;
        }
        ServerTardis tardis = ref.get().asServer();
        TravelHandler travel = tardis.travel();
        boolean previouslyLocked = (Boolean)tardis.door().previouslyLocked().get();
        if (tardis.siege().isActive()) {
            return;
        }
        if (travel.getState() == TravelHandlerBase.State.DEMAT) {
            return;
        }
        if (!previouslyLocked && travel.getState() == TravelHandlerBase.State.MAT && travel.getAlpha() >= 0.9f) {
            TardisUtil.teleportInside(tardis, entity);
        }
        if (!(tardis.door().isClosed() || DependencyChecker.hasPortals() && AITMod.CONFIG.allowPortalsBoti && tardis.getExterior().getVariant().hasPortals())) {
            TardisUtil.teleportInside(tardis, entity);
        }
        if (tardis.door().isClosed() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (tardis.isGrowth()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.growth.in_progress").method_27692(class_124.field_1061), true);
            }
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 blockState, ExteriorBlockEntity blockEntity) {
        TardisRef ref = this.tardis();
        if (ref == null || ref.isEmpty()) {
            return;
        }
        Tardis tardis = ref.get();
        TravelHandler travel = tardis.travel();
        TravelHandlerBase.State state = travel.getState();
        if (!world.method_8608()) {
            if (tardis.travel().isLanded()) {
                world.method_39279(this.method_11016(), AITBlocks.EXTERIOR_BLOCK, 2);
            }
            return;
        }
        if (AITModClient.CONFIG.renderDematParticles && !tardis.travel().isLanded() && tardis.travel().isHitboxShown()) {
            for (int ji = 0; ji < 4; ++ji) {
                double offsetX = AITMod.RANDOM.nextGaussian() * 0.125;
                double offsetY = AITMod.RANDOM.nextGaussian() * 0.125;
                double offsetZ = AITMod.RANDOM.nextGaussian() * 0.125;
                class_243 vec = new class_243(offsetX, offsetY, offsetZ);
                float offsetMultiplier = -0.1f;
                class_243 vec3d = class_243.method_24953((class_2382)pos);
                int i = class_2350.field_11036.method_10148();
                int j = class_2350.field_11036.method_10164();
                int k = class_2350.field_11036.method_10165();
                double d = vec3d.field_1352 + (i == 0 ? class_3532.method_15366((class_5819)world.field_9229, (double)-0.5, (double)0.5) : (double)i * (double)offsetMultiplier);
                double e = vec3d.field_1351 + (j == 0 ? class_3532.method_15366((class_5819)world.field_9229, (double)-0.5, (double)0.5) : (double)j * (double)offsetMultiplier) - (double)0.35f;
                double f = vec3d.field_1350 + (k == 0 ? class_3532.method_15366((class_5819)world.field_9229, (double)-0.5, (double)0.5) : (double)k * (double)offsetMultiplier);
                double g = i == 0 ? vec.method_10216() : 0.0;
                double h = j == 0 ? vec.method_10214() : 0.0;
                double l = k == 0 ? vec.method_10215() : 0.0;
                world.method_8406((class_2394)class_2398.field_11204, d, e, f, g, h, l);
                world.method_8406((class_2394)new class_2388(class_2398.field_11217, world.method_8320(pos.method_10074())), d, e, f, g, h, l);
            }
        }
        this.exteriorLightBlockState(blockState, pos, state);
    }

    private void exteriorLightBlockState(class_2680 blockState, class_2338 pos, TravelHandlerBase.State state) {
        if (!state.animated()) {
            return;
        }
        if (!blockState.method_27852(AITBlocks.EXTERIOR_BLOCK)) {
            return;
        }
        if (!this.isLinked()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        this.method_10997().method_8501(pos, (class_2680)blockState.method_11657((class_2769)ExteriorBlock.LEVEL_4, (Comparable)Integer.valueOf(class_3532.method_15340((int)Math.round(tardis.travel().getAlpha() * 4.0f), (int)0, (int)15))));
    }
}

