/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities;

import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.WaypointItem;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.data.Waypoint;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1768;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class WaypointBankBlockEntity
extends InteriorLinkableBlockEntity {
    private final WaypointData[] waypoints = new WaypointData[16];
    private int selected = -1;

    public WaypointBankBlockEntity(class_2338 pos, class_2680 state) {
        super(AITBlockEntityTypes.WAYPOINT_BANK_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void unselect() {
        this.selected = -1;
    }

    public void dropItems() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (WaypointData data : this.waypoints) {
            if (data == null) continue;
            stacks.add(data.toStack());
        }
        StackUtil.scatter(this.field_11863, this.field_11867, stacks);
    }

    public class_1269 onUse(class_1937 world, class_2680 state, class_1657 player, class_1268 hand, int slot) {
        if (!this.isLinked()) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (stack.method_7909() instanceof WaypointItem) {
            return this.insert(state, stack, slot);
        }
        if (player.method_5715()) {
            return this.take(state, player, slot);
        }
        return this.select(state, slot);
    }

    private class_1269 take(class_2680 state, class_1657 player, int slot) {
        if (this.selected != slot) {
            return class_1269.field_5814;
        }
        WaypointData waypoint = this.waypoints[slot];
        if (waypoint == null) {
            return class_1269.field_5814;
        }
        this.waypoints[slot] = null;
        this.sync(state);
        player.method_7270(waypoint.toStack());
        return class_1269.field_5812;
    }

    private class_1269 insert(class_2680 state, class_1799 stack, int slot) {
        WaypointData inserted = WaypointData.fromStack(stack);
        if (inserted == null || this.waypoints[slot] != null) {
            return class_1269.field_5814;
        }
        stack.method_7934(1);
        this.waypoints[slot] = inserted;
        this.sync(state);
        return class_1269.field_5812;
    }

    private class_1269 activate(int slot) {
        if (!this.isLinked()) {
            return class_1269.field_5814;
        }
        WaypointData data = this.waypoints[slot];
        if (data == null) {
            return class_1269.field_5814;
        }
        this.tardis().get().travel().forceDestination(data.pos);
        this.field_11863.method_45447(null, this.method_11016(), AITSounds.WAYPOINT_ACTIVATE, class_3419.field_15245);
        return class_1269.field_5812;
    }

    private class_1269 select(class_2680 state, int slot) {
        if (this.selected == slot && this.isLinked()) {
            return this.activate(slot);
        }
        this.selected = slot;
        this.sync(state);
        return class_1269.field_5812;
    }

    protected void sync(class_2680 state) {
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, state, state, 2);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2499 waypoints = nbt.method_10554("waypoints", 10);
        for (int i = 0; i < this.waypoints.length; ++i) {
            this.waypoints[i] = WaypointData.fromNbt(waypoints.method_10602(i));
        }
        this.selected = nbt.method_10568("selected");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2499 waypoints = new class_2499();
        for (int i = 0; i < this.waypoints.length; ++i) {
            WaypointData data = this.waypoints[i];
            class_2487 compound = new class_2487();
            if (data != null) {
                data.toNbt(compound);
            }
            waypoints.method_10531(i, (class_2520)compound);
        }
        nbt.method_10566("waypoints", (class_2520)waypoints);
        nbt.method_10575("selected", (short)this.selected);
    }

    @Override
    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2756 getHalf() {
        return null;
    }

    public WaypointData[] getWaypoints() {
        return this.waypoints;
    }

    public int getSelected() {
        return this.selected;
    }

    public record WaypointData(int color, String name, CachedDirectedGlobalPos pos) {
        private WaypointData(int color, Waypoint waypoint) {
            this(color, waypoint.name(), waypoint.getPos());
        }

        public static WaypointData fromStack(class_1799 stack) {
            if (!stack.method_7948().method_10545("pos")) {
                return null;
            }
            int color = ((class_1768)AITItems.WAYPOINT_CARTRIDGE).method_7800(stack);
            Waypoint waypoint = Waypoint.fromStack(stack);
            return new WaypointData(color, waypoint);
        }

        public class_1799 toStack() {
            class_1799 result = new class_1799((class_1935)AITItems.WAYPOINT_CARTRIDGE);
            WaypointItem.setPos(result, this.pos);
            result.method_7977((class_2561)class_2561.method_43470((String)this.name));
            if (this.color != 0xFFFFFF) {
                ((class_1768)AITItems.WAYPOINT_CARTRIDGE).method_7799(result, this.color);
            }
            return result;
        }

        public void toNbt(class_2487 nbt) {
            nbt.method_10569("color", this.color);
            nbt.method_10582("name", this.name);
            if (this.pos != null) {
                nbt.method_10566("pos", (class_2520)this.pos.toNbt());
            }
        }

        public static WaypointData fromNbt(class_2487 nbt) {
            if (nbt.method_33133()) {
                return null;
            }
            int color = nbt.method_10550("color");
            String name = nbt.method_10558("name");
            CachedDirectedGlobalPos pos = CachedDirectedGlobalPos.fromNbt(nbt.method_10562("pos"));
            return new WaypointData(color, name, pos);
        }
    }
}

