/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blockentities.control;

import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.blocks.control.RedstoneControlBlock;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.registry.impl.ControlRegistry;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public abstract class ControlBlockEntity
extends InteriorLinkableBlockEntity {
    private Control control;
    private ConsoleTypeSchema consoleType;
    private boolean onDelay = false;

    protected ControlBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.getControl() != null) {
            nbt.method_10582("controlId", this.getControl().id().toString());
        }
        if (this.getConsoleType() != null) {
            nbt.method_10582("consoleTypeId", this.getConsoleType().id().toString());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("controlId")) {
            this.setControlId(new class_2960(nbt.method_10558("controlId")));
        }
        if (nbt.method_10545("consoleTypeId")) {
            this.setConsoleId(new class_2960(nbt.method_10558("consoleTypeId")));
        }
    }

    public Control getControl() {
        return this.control;
    }

    public ConsoleTypeSchema getConsoleType() {
        if (this.consoleType == null) {
            this.consoleType = ConsoleRegistry.HARTNELL;
        }
        return this.consoleType;
    }

    public void setControlId(class_2960 id) {
        Optional<Control> found = ControlRegistry.fromId(id);
        if (found.isEmpty()) {
            return;
        }
        this.control = found.get();
    }

    public void setConsoleId(class_2960 id) {
        Optional found = ConsoleRegistry.getInstance().getOptional(id);
        if (found.isEmpty()) {
            return;
        }
        this.consoleType = (ConsoleTypeSchema)found.get();
    }

    public boolean run(class_3222 user, boolean isMine) {
        if (this.getControl() == null || this.onDelay) {
            return false;
        }
        TardisRef found = this.tardis();
        Tardis tardis = found.get();
        if (!(tardis instanceof ServerTardis)) {
            return false;
        }
        ServerTardis tardis2 = (ServerTardis)tardis;
        if (!this.control.canRun(tardis2, user)) {
            return false;
        }
        if (this.control.shouldHaveDelay(tardis2) && !this.onDelay) {
            this.createDelay(this.control.getDelayLength(tardis2));
        }
        Control.Result result = this.control.handleRun(tardis2, user, user.method_51469(), this.field_11867, isMine);
        this.method_10997().method_8396(null, this.field_11867, this.control.getSound(this.getConsoleType(), result), class_3419.field_15245, 0.7f, 1.0f);
        return result.isSuccess();
    }

    public boolean run(class_3222 user, RedstoneControlBlock.Mode mode) {
        return this.run(user, mode == RedstoneControlBlock.Mode.PUNCH);
    }

    public void createDelay(long ticks) {
        this.onDelay = true;
        Scheduler.get().runTaskLater(() -> {
            this.onDelay = false;
        }, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, ticks);
    }
}

