/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blocks;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.blockentities.AstralMapBlockEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7718;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class AstralMapBlock
extends class_2237
implements class_2343 {
    public static final int MAX_ROTATION_INDEX = class_7718.method_45478();
    private static final int MAX_ROTATIONS = MAX_ROTATION_INDEX + 1;
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2960 REQUEST_SEARCH = AITMod.id("c2s/request_search");
    public static final class_2960 SYNC_STRUCTURES = AITMod.id("s2c/sync_structures");
    public static List<class_2960> structureIds;

    public AstralMapBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return AITBlockEntityTypes.ASTRAL_MAP.method_11032(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof AstralMapBlockEntity && !world.method_8608()) {
            AstralMapBlock.sendStructures((class_3218)world, (class_3222)player);
            player.method_5783((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
            AITMod.openScreen((class_3222)player, 2);
        }
        return class_1269.field_5812;
    }

    private static Optional<class_6880.class_6883<class_3195>> getStructure(class_3218 world, class_2960 id) {
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)id);
        return registry.method_40264(key);
    }

    private static void handleRequest(class_3222 player, class_2960 target) {
        player.method_7353((class_2561)class_2561.method_43470((String)"SEARCHING FOR STRUCTURE..."), false);
        class_3218 world = player.method_51469();
        class_2338 pos = player.method_24515();
        if (TardisServerWorld.isTardisDimension(world)) {
            ServerTardis tardis = ((TardisServerWorld)world).getTardis();
            CachedDirectedGlobalPos tPos = tardis.travel().position();
            class_6880.class_6883 targetStructure = AstralMapBlock.getStructure(world = tPos.getWorld(), target).orElse(null);
            if (targetStructure == null) {
                AITMod.LOGGER.error("Structure not found: {}", (Object)target);
                return;
            }
            pos = tPos.getPos();
            AsyncLocatorUtil.locate(world, (class_6885<class_3195>)class_6885.method_40246((class_6880[])new class_6880[]{targetStructure}), pos, 256, false).thenOnServerThread(pPos -> {
                class_2338 newPos;
                class_2338 class_23382 = newPos = pPos != null ? (class_2338)pPos.getFirst() : null;
                if (newPos != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("SUCCESS! FOUND AT " + newPos.method_10263() + ", " + newPos.method_10264() + ", " + newPos.method_10260() + " ( " + Math.round(Math.sqrt(newPos.method_19770((class_2374)player.method_19538()))) + " blocks away )")), false);
                    tardis.travel().destination(destination -> destination.pos(newPos));
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"404: STRUCTURE NOT FOUND"), false);
                }
            });
        }
    }

    private static void sendStructures(class_3218 world, class_3222 target) {
        if (structureIds == null || structureIds.isEmpty()) {
            ArrayList<class_2960> ids = new ArrayList<class_2960>();
            class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
            for (class_3195 entry : registry) {
                ids.add(registry.method_10221((Object)entry));
            }
            structureIds = ids;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(structureIds.size());
        for (class_2960 id : structureIds) {
            buf.method_10812(id);
        }
        ServerPlayNetworking.send((class_3222)target, (class_2960)SYNC_STRUCTURES, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerSyncListener() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_STRUCTURES, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            ArrayList<class_2960> ids = new ArrayList<class_2960>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(buf.method_10810());
            }
            structureIds = ids;
        });
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(class_7718.method_45479((float)ctx.method_8044())));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation.method_10502(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirror.method_10344(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ROTATION});
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_SEARCH, (server, player, handler, buf, responseSender) -> {
            try {
                class_2960 target = buf.method_10810();
                AstralMapBlock.handleRequest(player, target);
            }
            catch (Exception e) {
                AITMod.LOGGER.error("Error handling search request", (Throwable)e);
            }
        });
    }
}

