/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import dev.amble.ait.core.engine.link.IFluidLink;
import dev.amble.ait.core.engine.link.block.CableBlockEntity;
import dev.amble.ait.core.engine.link.block.FluidLinkBlock;
import dev.amble.ait.core.engine.link.block.FluidLinkBlockEntity;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class CableBlock
extends FluidLinkBlock
implements class_3737 {
    private static final class_2350[] FACINGS = class_2350.values();
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = ImmutableMap.copyOf((Map)((Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), directions -> {
        directions.put(class_2350.field_11043, NORTH);
        directions.put(class_2350.field_11034, EAST);
        directions.put(class_2350.field_11035, SOUTH);
        directions.put(class_2350.field_11039, WEST);
        directions.put(class_2350.field_11036, UP);
        directions.put(class_2350.field_11033, DOWN);
    })));
    protected final class_265[] connectionsToShape;

    public CableBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
        this.connectionsToShape = this.generateFacingsToShapeMap(0.2f);
    }

    private class_265[] generateFacingsToShapeMap(float radius) {
        float f = 0.5f - radius;
        float g = 0.5f + radius;
        class_265 voxelShape = class_2248.method_9541((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f));
        class_265[] voxelShapes = new class_265[FACINGS.length];
        for (int i = 0; i < FACINGS.length; ++i) {
            class_2350 direction = FACINGS[i];
            voxelShapes[i] = class_259.method_1081((double)(0.5 + Math.min((double)(-radius), (double)direction.method_10148() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.method_10164() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.method_10165() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.method_10148() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.method_10164() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.method_10165() * 0.5)));
        }
        class_265[] voxelShapes2 = new class_265[64];
        for (int j = 0; j < 64; ++j) {
            class_265 voxelShape2 = voxelShape;
            for (int k = 0; k < FACINGS.length; ++k) {
                if ((j & 1 << k) == 0) continue;
                voxelShape2 = class_259.method_1084((class_265)voxelShape2, (class_265)voxelShapes[k]);
            }
            voxelShapes2[j] = voxelShape2;
        }
        return voxelShapes2;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        boolean bl = neighborState.method_27852((class_2248)this) || neighborState.method_26204() instanceof IFluidLink;
        return (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(bl));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.connectionsToShape[this.getConnectionMask(state)];
    }

    protected int getConnectionMask(class_2680 state) {
        int i = 0;
        for (int j = 0; j < FACINGS.length; ++j) {
            if (!((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(FACINGS[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)this.withConnectionProperties((class_1922)ctx.method_8045(), ctx.method_8037()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 withConnectionProperties(class_1922 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos.method_10074());
        class_2680 blockState2 = world.method_8320(pos.method_10084());
        class_2680 blockState3 = world.method_8320(pos.method_10095());
        class_2680 blockState4 = world.method_8320(pos.method_10078());
        class_2680 blockState5 = world.method_8320(pos.method_10072());
        class_2680 blockState6 = world.method_8320(pos.method_10067());
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(blockState.method_27852((class_2248)this) || blockState.method_26204() instanceof IFluidLink))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(blockState2.method_27852((class_2248)this) || blockState2.method_26204() instanceof IFluidLink))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(blockState3.method_27852((class_2248)this) || blockState3.method_26204() instanceof IFluidLink))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(blockState4.method_27852((class_2248)this) || blockState4.method_26204() instanceof IFluidLink))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(blockState5.method_27852((class_2248)this) || blockState5.method_26204() instanceof IFluidLink))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(blockState6.method_27852((class_2248)this) || blockState6.method_26204() instanceof IFluidLink));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, UP, DOWN}).method_11667(new class_2769[]{WATERLOGGED});
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public FluidLinkBlockEntity createBlockEntity(class_2338 pos, class_2680 state) {
        return new CableBlockEntity(pos, state);
    }
}

