/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blocks;

import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.item.HammerItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.console.type.CopperType;
import dev.amble.ait.data.schema.console.type.CrystallineType;
import dev.amble.lib.api.ICantBreak;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleBlock
extends HorizontalDirectionalBlock
implements class_2343,
ICantBreak {
    private static final class_265 SHAPE;

    public ConsoleBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ConsoleBlockEntity(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        ConsoleBlockEntity consoleBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ConsoleBlockEntity) {
            consoleBlockEntity = (ConsoleBlockEntity)blockEntity;
            if (world.method_27983().equals(class_1937.field_25179)) {
                return class_1269.field_5814;
            }
            consoleBlockEntity.useOn(world, player.method_5715(), player);
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7909() instanceof HammerItem) {
                itemStack.method_7909().method_7884(new class_1838(world, player, hand, itemStack, hit));
            }
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (blockEntity instanceof ConsoleBlockEntity && !(consoleBlockEntity = (ConsoleBlockEntity)blockEntity).method_5442()) {
            player.method_17355((class_3908)consoleBlockEntity);
            world.method_8396(null, pos, AITSounds.DOOM_DOOR_OPEN, class_3419.field_15245, 1.0f, 0.7f);
        }
        return class_1269.field_5812;
    }

    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return (world1, blockPos, blockState, ticker) -> {
            if (ticker instanceof ConsoleBlockEntity) {
                ConsoleBlockEntity console = (ConsoleBlockEntity)ticker;
                console.tick(world, blockPos, blockState, console);
            }
        };
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ConsoleBlockEntity) {
            ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)class_25862;
            if (world.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            consoleBlockEntity.markNeedsControl();
        }
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        ConsoleBlockEntity console;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ConsoleBlockEntity && (console = (ConsoleBlockEntity)blockEntity).isLinked()) {
            Tardis tardis = console.tardis().get();
            if (console.tardis().get().fuel().hasPower()) {
                return 15;
            }
        }
        return 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.method_9524(state, world, pos, direction);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!TardisServerWorld.isTardisDimension(world)) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Random random = new Random();
            int x_random = random.nextInt(1, 10);
            int y_random = random.nextInt(1, 10);
            int z_random = random.nextInt(1, 10);
            boolean is_x_negative = false;
            boolean is_z_negative = false;
            if (random.nextInt(1, 3) == 1) {
                is_x_negative = true;
            }
            if (random.nextInt(1, 3) == 1) {
                is_z_negative = true;
            }
            world.method_8396(null, pos, AITSounds.CLOISTER, class_3419.field_15245, 4.0f, 1.0f);
            player.method_5762((double)(0.15f * (float)x_random * (float)(is_x_negative ? -1 : 1)), (double)(0.1f * (float)y_random), (double)(0.15f * (float)z_random * (float)(is_z_negative ? -1 : 1)));
            if (player instanceof class_3222) {
                for (int i = 0; i < 100; ++i) {
                    ((class_3218)world).method_14199((class_2394)class_2398.field_11231, (double)((float)pos.method_10263() + random.nextFloat(-2.0f, 3.0f)), (double)((float)pos.method_10264() + random.nextFloat(2.0f)), (double)((float)pos.method_10260() + random.nextFloat(-2.0f, 3.0f)), 1, (double)random.nextFloat(-5.0f, 5.0f), (double)random.nextFloat(-5.0f, 5.0f), (double)random.nextFloat(-5.0f, 5.0f), 1.0);
                }
            }
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ConsoleBlockEntity) {
            ConsoleBlockEntity console = (ConsoleBlockEntity)class_25862;
            console.onBroken();
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ConsoleBlockEntity) {
            ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)blockEntity;
            if (!consoleBlockEntity.isLinked()) {
                return;
            }
            if (!consoleBlockEntity.tardis().get().fuel().hasPower()) {
                return;
            }
            double d = pos.method_10263();
            double e = pos.method_10264();
            double f = pos.method_10260();
            if (consoleBlockEntity.getTypeSchema() instanceof CrystallineType) {
                for (int i = 0; i < random.method_43048(15) + 1; ++i) {
                    boolean bl = random.method_43056();
                    float particleSpeed = random.method_43057() / 15.0f;
                    world.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.0, (double)pos.method_10260() + 0.5, bl ? (double)particleSpeed : (double)(-particleSpeed), 0.0022, bl ? (double)particleSpeed : (double)(-particleSpeed));
                    world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.1, 0.0);
                }
                return;
            }
            if (consoleBlockEntity.tardis() != null && !consoleBlockEntity.tardis().get().extra().getInsertedDisc().method_7960() && consoleBlockEntity.getTypeSchema() instanceof CopperType) {
                for (int i = 0; i < random.method_43048(10) + 1; ++i) {
                    boolean bl = random.method_43056();
                    float b = (float)world.method_8409().method_43048(4) / 24.0f;
                    world.method_8406((class_2394)class_2398.field_11224, d + 1.4, e + 2.6, f - (double)0.15f, (double)b + 1.5, (double)b, (double)b + 0.5);
                }
            }
        }
    }

    public void onTryBreak(class_1937 world, class_2338 pos, class_2680 state) {
        if (TardisServerWorld.isTardisDimension(world)) {
            return;
        }
        world.method_22352(pos, true);
    }

    static {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.875, (double)-0.25, (double)1.0, (double)1.0, (double)1.25), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)-0.25, (double)0.875, (double)0.0, (double)1.25, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)-0.1875, (double)0.875, (double)-0.125, (double)1.1875, (double)1.0, (double)0.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)-0.1875, (double)0.875, (double)1.0, (double)1.1875, (double)1.0, (double)1.125), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)1.0, (double)0.875, (double)-0.1875, (double)1.125, (double)1.0, (double)1.1875), (class_247)class_247.field_1366);
        SHAPE = shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)-0.125, (double)0.875, (double)-0.1875, (double)0.0, (double)1.0, (double)1.1875), (class_247)class_247.field_1366);
    }
}

