/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blocks;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.util.TooltipUtil;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.blockentities.CoralBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.manager.TardisBuilder;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.variant.growth.CoralGrowthVariant;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2492;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CoralPlantBlock
extends HorizontalDirectionalBlock
implements class_2343 {
    private final class_265 DEFAULT = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final class_2758 AGE = class_2741.field_12550;

    public CoralPlantBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected class_2758 getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.getAgeProperty());
    }

    public final boolean isMature(class_2680 blockState) {
        return this.getAge(blockState) >= this.getMaxAge();
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        class_243 centre = pos.method_10084().method_46558();
        for (int i = 0; i < this.getAge(state); ++i) {
            double offsetX = AITMod.RANDOM.nextGaussian() * (double)this.getAge(state) * (double)0.01f;
            double offsetY = AITMod.RANDOM.nextGaussian() * (double)this.getAge(state) * (double)0.01f;
            double offsetZ = AITMod.RANDOM.nextGaussian() * (double)this.getAge(state) * (double)0.01f;
            world.method_8406((class_2394)AITMod.CORAL_PARTICLE, centre.method_10216(), centre.method_10214(), centre.method_10215(), offsetX, offsetY, offsetZ);
        }
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int i;
        if (world.method_22335(pos, 0) >= 4 && (i = this.getAge(state)) < this.getMaxAge()) {
            if (!(world.method_8320(pos.method_10074()).method_26204() instanceof class_2492)) {
                world.method_22352(pos, true);
                return;
            }
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
        this.tryCreate(world, pos, state);
    }

    private boolean tryCreate(class_3218 world, class_2338 pos, class_2680 state) {
        if (!this.isMature(state)) {
            return false;
        }
        if (TardisServerWorld.isTardisDimension(world)) {
            this.createConsole(world, pos);
            return true;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CoralBlockEntity) {
            CoralBlockEntity coral = (CoralBlockEntity)class_25862;
            this.createTardis(world, pos, coral.creator, state);
        }
        return true;
    }

    private void createConsole(class_3218 world, class_2338 pos) {
        world.method_45447(null, pos, AITSounds.FABRICATOR_END, class_3419.field_15245);
        world.method_8501(pos, AITBlocks.CONSOLE.method_9564());
    }

    private void createTardis(class_3218 world, class_2338 pos, UUID creatorId, class_2680 state) {
        class_1657 class_16572 = world.method_18470(creatorId);
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        TardisBuilder builder = new TardisBuilder().at(CachedDirectedGlobalPos.create(world, pos, CachedDirectedGlobalPos.getGeneralizedRotation((class_2350)((class_2350)state.method_11654((class_2769)FACING))))).owner(player).with(TardisComponent.Id.FUEL, fuel -> fuel.setCurrentFuel(5000.0)).with(TardisComponent.Id.LOYALTY, loyaltyHandler -> loyaltyHandler.set(player, new Loyalty(Loyalty.Type.NEUTRAL))).with(TardisComponent.Id.TRAVEL, travel -> travel.tardis().travel().autopilot(false)).exterior((ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(CoralGrowthVariant.REFERENCE)).desktop(DesktopRegistry.DEFAULT_CAVE);
        ServerTardis created = ServerTardisManager.getInstance().create(builder);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!(placer instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)placer;
        if (!RiftChunkManager.isRiftChunk((class_5281)((class_3218)world), pos) && !TardisServerWorld.isTardisDimension((class_3218)world)) {
            world.method_22352(pos, !placer.method_31747() || !player.method_7337());
            return;
        }
        if (!(world.method_8320(pos.method_10074()).method_26204() instanceof class_2492)) {
            world.method_22352(pos, !placer.method_31747() || !player.method_7337());
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CoralBlockEntity) {
            CoralBlockEntity coral = (CoralBlockEntity)class_25862;
            if (player.method_5667() != null) {
                coral.creator = player.method_5667();
                coral.method_5431();
            }
            TardisCriterions.PLACE_CORAL.trigger(player);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return (world.method_22335(pos, 0) >= 4 || world.method_8311(pos)) && super.method_9558(state, world, pos);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1584 && world.method_8450().method_8355(class_1928.field_19388)) {
            world.method_8651(pos, true, entity);
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.DEFAULT;
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return this.DEFAULT;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return AITBlocks.CORAL_PLANT.method_8389().method_7854();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE}).method_11667(new class_2769[]{FACING});
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        TooltipUtil.addShiftHiddenTooltip(stack, tooltip, tooltips -> tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.ait.tardis_coral").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CoralBlockEntity(pos, state);
    }
}

