/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blocks;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.util.TooltipUtil;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.blockentities.MatrixEnergizerBlockEntity;
import dev.amble.ait.core.item.PersonalityMatrixItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5705;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7133;
import net.minecraft.class_7244;
import net.minecraft.class_7268;
import net.minecraft.class_8514;
import org.jetbrains.annotations.Nullable;

public class MatrixEnergizerBlock
extends class_2248
implements class_2343 {
    private final class_265 DEFAULT = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    public static final class_2754<class_5705> SENSOR_PHASE = class_2741.field_28120;
    public static final class_2758 AGE = class_2741.field_12497;
    public static final class_2746 HAS_POWER = class_2746.method_11825((String)"has_power");
    public static final class_2746 SILENT = class_2746.method_11825((String)"silent");

    public MatrixEnergizerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HAS_POWER, (Comparable)Boolean.valueOf(false))).method_11657(SENSOR_PHASE, (Comparable)class_5705.field_28121)).method_11657((class_2769)SILENT, (Comparable)Boolean.valueOf(true)));
    }

    public static boolean isInactive(class_2680 blockState) {
        return blockState.method_11654(SENSOR_PHASE) == class_5705.field_28121;
    }

    protected class_2758 getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public int getAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.getAgeProperty());
    }

    public final boolean isMature(class_2680 blockState) {
        return this.getAge(blockState) >= this.getMaxAge();
    }

    public static boolean hasPower(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HAS_POWER);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_8137) && !MatrixEnergizerBlock.hasPower(state)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_POWER, (Comparable)Boolean.valueOf(true)));
            stack.method_7934(1);
            world.method_8396(null, pos, class_3417.field_14891, class_3419.field_15245, 1.0f, 0.6f);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (MatrixEnergizerBlock.getPhase(state) != class_5705.field_28122) {
            if (MatrixEnergizerBlock.getPhase(state) == class_5705.field_44631) {
                world.method_8652(pos, (class_2680)state.method_11657(SENSOR_PHASE, (Comparable)class_5705.field_28121), 3);
            }
            return;
        }
        MatrixEnergizerBlock.setCooldown((class_1937)world, pos, state);
    }

    public static class_5705 getPhase(class_2680 state) {
        return (class_5705)state.method_11654(SENSOR_PHASE);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        class_243 centre = pos.method_10084().method_46558();
        if (MatrixEnergizerBlock.hasPower(state)) {
            for (int i = 0; i < this.getAge(state); ++i) {
                double offsetX = AITMod.RANDOM.nextGaussian() * (double)this.getAge(state) * (double)0.01f;
                double offsetY = AITMod.RANDOM.nextGaussian() * (double)this.getAge(state) * (double)0.01f;
                double offsetZ = AITMod.RANDOM.nextGaussian() * (double)this.getAge(state) * (double)0.01f;
                world.method_8406((class_2394)AITMod.CORAL_PARTICLE, centre.method_10216(), centre.method_10214() - (double)0.65f, centre.method_10215(), offsetX, offsetY, offsetZ);
                world.method_8406((class_2394)class_2398.field_38002, centre.method_10216(), centre.method_10214() - (double)0.65f, centre.method_10215(), offsetX, offsetY, offsetZ);
                world.method_8406((class_2394)class_2398.field_22246, centre.method_10216(), centre.method_10214() - (double)0.65f, centre.method_10215(), offsetX, offsetY, offsetZ);
            }
        }
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.tryCreate((class_1937)world, pos, state);
        this.shriekerShrieks(state, (class_1937)world, pos);
    }

    public void shriekerShrieks(class_2680 thisState, class_1937 world, class_2338 pos) {
        MatrixEnergizerBlockEntity mbe;
        if (world.method_8608()) {
            return;
        }
        if (!(world.method_8320(pos.method_10074()).method_26204() instanceof class_7268) || !((Boolean)world.method_8320(pos.method_10074()).method_11654((class_2769)class_7268.field_38422)).booleanValue()) {
            return;
        }
        if (!((Boolean)world.method_8320(pos.method_10074()).method_11654((class_2769)class_7268.field_38229)).booleanValue()) {
            return;
        }
        if (!MatrixEnergizerBlock.hasPower(world.method_8320(pos))) {
            return;
        }
        class_2586 be = world.method_8321(pos);
        class_2680 state = world.method_8320(pos.method_10074());
        if (be instanceof MatrixEnergizerBlockEntity && (mbe = (MatrixEnergizerBlockEntity)be).method_51299().method_32970((class_3218)world, pos, class_5712.field_38244, class_5712.class_7397.method_43287((class_2680)thisState))) {
            mbe.getEventListener().method_51403((class_3218)world, class_5712.field_38244, class_5712.class_7397.method_43287((class_2680)state), new class_243((double)pos.method_10074().method_10263(), (double)pos.method_10074().method_10264(), (double)pos.method_10074().method_10260()));
            int i = this.getAge(thisState);
            if (i < this.getMaxAge()) {
                world.method_8652(pos, (class_2680)thisState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                this.tryCreate(world, pos, thisState);
            }
        }
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (MatrixEnergizerBlock.hasPower(state) && this.getAge(state) == this.getMaxAge()) {
            class_1799 pmStack = PersonalityMatrixItem.randomize();
            MatrixEnergizerBlock.method_9577((class_1937)((class_1937)world), (class_2338)pos, (class_1799)pmStack);
        }
        super.method_9585(world, pos, state);
    }

    private boolean tryCreate(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return false;
        }
        if (this.isMature(state) && MatrixEnergizerBlock.hasPower(state)) {
            world.method_8396(null, pos, class_3417.field_37364, class_3419.field_15245, 1.0f, 1.0f);
            class_1799 pmStack = PersonalityMatrixItem.randomize();
            class_1542 matrix = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), pmStack);
            world.method_8649((class_1297)matrix);
            if (world.method_8321(pos.method_10074()) instanceof class_7133) {
                class_7244.method_42122((class_1299)class_1299.field_38095, (class_3730)class_3730.field_16461, (class_3218)((class_3218)world), (class_2338)pos.method_10074(), (int)20, (int)5, (int)6, (class_7244.class_7502)class_7244.class_7502.field_39401).isPresent();
            }
            world.method_22352(pos, false);
            return true;
        }
        return false;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!(placer instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)placer;
        state.method_11657((class_2769)SILENT, (Comparable)Boolean.valueOf(true));
        if (!(world.method_8320(pos.method_10074()).method_26204() instanceof class_7268)) {
            world.method_22352(pos, false);
            if (!player.method_7337()) {
                MatrixEnergizerBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)AITBlocks.MATRIX_ENERGIZER.method_8389().method_7854());
            }
            return;
        }
        if (world.method_8321(pos) instanceof MatrixEnergizerBlockEntity) {
            TardisCriterions.PLACE_ENERGIZER.trigger(player);
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.DEFAULT;
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return this.DEFAULT;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return AITBlocks.MATRIX_ENERGIZER.method_8389().method_7854();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE}).method_11667(new class_2769[]{HAS_POWER}).method_11667(new class_2769[]{SENSOR_PHASE}).method_11667(new class_2769[]{SILENT});
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        TooltipUtil.addShiftHiddenTooltip(stack, tooltip, tooltips -> tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.ait.matrix_energizer").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})));
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (!world.field_9236) {
            return MatrixEnergizerBlock.checkType(type, AITBlockEntityTypes.MATRIX_ENERGIZER_BLOCK_ENTITY_TYPE, (worldx, pos, statex, blockEntity) -> {
                class_8514.class_8517.method_51406((class_1937)worldx, (class_8514.class_8515)blockEntity.method_51298(), (class_8514.class_5719)blockEntity.method_51299());
                this.shriekerShrieks(statex, worldx, pos);
            });
        }
        return null;
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public static void setCooldown(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, (class_2680)state.method_11657(SENSOR_PHASE, (Comparable)class_5705.field_44631), 3);
        world.method_39279(pos, state.method_26204(), 10);
        MatrixEnergizerBlock.updateNeighbors(world, pos, state);
    }

    private static void updateNeighbors(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        world.method_8452(pos, block);
        world.method_8452(pos.method_10074(), block);
        state.method_11657((class_2769)SILENT, (Comparable)Boolean.valueOf(true));
    }

    public int getCooldownTime() {
        return 15;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MatrixEnergizerBlockEntity(pos, state);
    }

    public void setActive(class_1937 world, class_2338 pos, class_2680 state, int frequency) {
        world.method_8652(pos, (class_2680)state.method_11657(SENSOR_PHASE, (Comparable)class_5705.field_28122), 3);
        world.method_39279(pos, state.method_26204(), this.getCooldownTime());
        MatrixEnergizerBlock.updateNeighbors(world, pos, state);
    }
}

