/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.blocks;

import dev.amble.ait.core.blockentities.WaypointBankBlockEntity;
import dev.amble.ait.core.blocks.types.HorizontalDirectionalBlock;
import dev.amble.ait.core.util.WorldUtil;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class WaypointBankBlock
extends HorizontalDirectionalBlock
implements class_2343 {
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final int MAX_COUNT = 16;

    public WaypointBankBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2756.field_12607));
    }

    private static int getSlotForHitPos(class_241 hitPos, class_2756 half) {
        int column;
        int n = column = hitPos.field_1343 >= 0.5f ? 1 : 0;
        if (half == class_2756.field_12609) {
            return column * 8;
        }
        int row = (int)((1.0f - hitPos.field_1342) * 16.0f / 2.0f);
        row = class_3532.method_15340((int)row, (int)0, (int)6);
        return row + column * 8 + 1;
    }

    private static Optional<class_241> getHitPos(class_3965 hit, class_2350 facing) {
        class_2350 direction = hit.method_17780();
        if (facing != direction) {
            return Optional.empty();
        }
        class_2338 blockPos = hit.method_17777().method_10093(direction);
        class_243 vec3d = hit.method_17784().method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        double x = vec3d.method_10216();
        double y = vec3d.method_10214();
        double z = vec3d.method_10215();
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> Optional.of(new class_241((float)(1.0 - x), (float)y));
            case class_2350.field_11035 -> Optional.of(new class_241((float)x, (float)y));
            case class_2350.field_11039 -> Optional.of(new class_241((float)z, (float)y));
            case class_2350.field_11034 -> Optional.of(new class_241((float)(1.0 - z), (float)y));
            case class_2350.field_11033, class_2350.field_11036 -> Optional.empty();
        };
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof WaypointBankBlockEntity) {
            WaypointBankBlockEntity bank = (WaypointBankBlockEntity)class_25862;
            bank.unselect();
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        Optional<class_241> hitPos = WaypointBankBlock.getHitPos(hit, (class_2350)state.method_11654((class_2769)class_2383.field_11177));
        if (hitPos.isEmpty()) {
            return class_1269.field_5811;
        }
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
        }
        if (!((class_25862 = world.method_8321(pos)) instanceof WaypointBankBlockEntity)) {
            return class_1269.field_5811;
        }
        WaypointBankBlockEntity bank = (WaypointBankBlockEntity)class_25862;
        int slot = WaypointBankBlock.getSlotForHitPos(hitPos.get(), (class_2756)state.method_11654(HALF));
        return bank.onUse(world, state, player, hand, slot);
    }

    public long method_9535(class_2680 state, class_2338 pos) {
        return class_3532.method_15371((int)pos.method_10263(), (int)pos.method_10087(state.method_11654(HALF) == class_2756.field_12607 ? 0 : 1).method_10264(), (int)pos.method_10260());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return null;
        }
        return new WaypointBankBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, HALF});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        world.method_8652(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (direction.method_10166() == class_2350.class_2351.field_11052 && half == class_2756.field_12607 == (direction == class_2350.field_11036)) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) != half ? (class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)neighborState.method_11654((class_2769)FACING))) : class_2246.field_10124.method_9564();
        }
        return half == class_2756.field_12607 && direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        if (blockPos.method_10264() < world.method_31600() - 1 && world.method_8320(blockPos.method_10084()).method_26166(ctx)) {
            return (class_2680)super.method_9605(ctx).method_11657(HALF, (Comparable)class_2756.field_12607);
        }
        return null;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && player.method_7337()) {
            WorldUtil.onBreakHalfInCreative(world, pos, state, player);
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof WaypointBankBlockEntity) {
            WaypointBankBlockEntity bank = (WaypointBankBlockEntity)class_25862;
            bank.dropItems();
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }
}

