/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.JsonElementArgumentType;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class DataCommand {
    public static final SuggestionProvider<class_2168> COMPONENT_SUGGESTION = (context, builder) -> class_2172.method_9264(TardisComponentRegistry.getInstance().getValues().stream().map(TardisComponent.IdLike::name), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<class_2168> VALUE_SUGGESTION = (context, builder) -> {
        ServerTardis tardis = TardisArgumentType.getTardis((CommandContext<class_2168>)context, "tardis");
        String rawComponent = StringArgumentType.getString((CommandContext)context, (String)"component");
        TardisComponent.IdLike id = TardisComponentRegistry.getInstance().get(rawComponent);
        Object patt0$temp = tardis.handler(id);
        if (!(patt0$temp instanceof KeyedTardisComponent)) {
            return builder.buildFuture();
        }
        KeyedTardisComponent keyed = (KeyedTardisComponent)patt0$temp;
        return class_2172.method_9264(keyed.getPropertyData().values().stream().map(value -> value.getProperty().getName()), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"data").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.data", 2))).then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9244((String)"component", (ArgumentType)StringArgumentType.word()).suggests(COMPONENT_SUGGESTION).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.word()).suggests(VALUE_SUGGESTION).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"data", (ArgumentType)JsonElementArgumentType.jsonElement()).executes(DataCommand::runSet)))).then(class_2170.method_9247((String)"get").executes(DataCommand::runGet)))))));
    }

    private static <T> int runGet(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Value<T> value = DataCommand.getValue(context, tardis);
        if (value == null) {
            return 0;
        }
        T obj = value.get();
        String json = ServerTardisManager.getInstance().getFileGson().toJson(obj);
        source.method_45068((class_2561)class_2561.method_43469((String)"command.ait.data.get", (Object[])new Object[]{value.getProperty().getName(), json}));
        return 1;
    }

    private static <T> int runSet(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Value<Object> value = DataCommand.getValue(context, tardis);
        if (value == null) {
            return 0;
        }
        JsonElement data = JsonElementArgumentType.getJsonElement(context, "data");
        Class<?> classOfT = value.getProperty().getType().getClazz();
        Object obj = ServerTardisManager.getInstance().getFileGson().fromJson(data, classOfT);
        value.set(obj);
        source.method_45068((class_2561)class_2561.method_43469((String)"command.ait.data.set", (Object[])new Object[]{value.getProperty().getName(), obj.toString()}));
        return 1;
    }

    private static <T> Value<T> getValue(CommandContext<class_2168> context, Tardis tardis) {
        String valueName = StringArgumentType.getString(context, (String)"value");
        String rawComponent = StringArgumentType.getString(context, (String)"component");
        TardisComponent.IdLike id = TardisComponentRegistry.getInstance().get(rawComponent);
        Object t = tardis.handler(id);
        if (!(t instanceof KeyedTardisComponent)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.ait.data.fail", (Object[])new Object[]{valueName, rawComponent}));
            return null;
        }
        KeyedTardisComponent keyed = (KeyedTardisComponent)t;
        return keyed.getPropertyData().getExact(valueName);
    }
}

