/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.api.tardis.WorldWithTardis;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class DebugCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.debug", 2))).executes(DebugCommand::execute)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).executes(DebugCommand::executeTardis)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(DebugCommand::executePlayer)))));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            return 1;
        }
        class_3218 world = source.method_9225();
        class_3222 player = source.method_44023();
        LandingPadRegion region = LandingPadManager.getInstance(world).getRegion(player.method_31476());
        if (region != null) {
            source.method_45068((class_2561)class_2561.method_43470((String)("LP in chunk: " + String.valueOf(region))));
        }
        ((WorldWithTardis)((class_2168)context.getSource()).method_9225()).ait$withLookup(lookup -> {
            source.method_45068((class_2561)class_2561.method_43473());
            source.method_45068((class_2561)class_2561.method_43470((String)("TARDIS in chunk: " + String.valueOf(lookup.get(source.method_44023().method_31476())))));
        });
        return 1;
    }

    private static int executeTardis(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            return 0;
        }
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        ((class_2168)context.getSource()).method_9211().method_40000(() -> {
            tardis.chameleon().clearDisguise();
            tardis.chameleon().applyDisguise();
        });
        return 1;
    }

    private static int executePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        long start = System.nanoTime();
        NetworkUtil.hasLinkedItem(tardis, player);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Checked player in " + (System.nanoTime() - start) + "ns")), false);
        return 1;
    }
}

