/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.util.TextUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class FuelCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fuel").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel", 2))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)50000.0)).executes(FuelCommand::add))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel.remove", 2))).then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)50000.0)).executes(FuelCommand::remove))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel.set", 2))).then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)50000.0)).executes(FuelCommand::set))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.fuel.get", 2))).then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).executes(FuelCommand::get)))));
    }

    private static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        double fuel = DoubleArgumentType.getDouble(context, (String)"amount");
        tardis.addFuel(fuel);
        source.method_45068((class_2561)class_2561.method_43469((String)"message.ait.fuel.add", (Object[])new Object[]{fuel, TextUtil.forTardis(tardis), tardis.getFuel()}));
        return 1;
    }

    private static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        double fuel = DoubleArgumentType.getDouble(context, (String)"amount");
        tardis.removeFuel(fuel);
        source.method_45068((class_2561)class_2561.method_43469((String)"message.ait.fuel.remove", (Object[])new Object[]{fuel, TextUtil.forTardis(tardis), tardis.getFuel()}));
        return 1;
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        double fuel = DoubleArgumentType.getDouble(context, (String)"amount");
        if (fuel > 50000.0) {
            source.method_45068((class_2561)class_2561.method_43471((String)"message.ait.fuel.max"));
            return 0;
        }
        tardis.setFuelCount(fuel);
        source.method_45068((class_2561)class_2561.method_43469((String)"message.ait.fuel.set", (Object[])new Object[]{TextUtil.forTardis(tardis), fuel}));
        return 1;
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        double fuel = tardis.fuel().getCurrentFuel();
        source.method_45068((class_2561)class_2561.method_43469((String)"message.ait.fuel.get", (Object[])new Object[]{TextUtil.forTardis(tardis), fuel}));
        return (int)fuel;
    }
}

