/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.util.TextUtil;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class ListCommand {
    private static final Map<String, Function<ServerTardis, String>> SEARCH_TYPES = Map.of("id", tardis -> tardis.getUuid().toString(), "owner", tardis -> tardis.stats().getPlayerCreatorName(), "name", tardis -> tardis.stats().getName());

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.list", 2))).executes(ListCommand::list)).then(class_2170.method_9244((String)"search-args", (ArgumentType)StringArgumentType.greedyString()).executes(ListCommand::search))));
    }

    public static int list(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_45068((class_2561)class_2561.method_43470((String)"TARDIS':"));
        ServerTardisManager.getInstance().forEach(tardis -> ListCommand.sendTardis(source, tardis));
        return 1;
    }

    public static int search(CommandContext<class_2168> context) {
        String args = StringArgumentType.getString(context, (String)"search-args");
        class_2168 source = (class_2168)context.getSource();
        source.method_45068((class_2561)class_2561.method_43471((String)"command.ait.list.tardises"));
        String[] parts = args.split(":");
        String type = parts[0];
        try {
            Function<ServerTardis, String> func = SEARCH_TYPES.get(type);
            if (func == null) {
                throw new IllegalArgumentException();
            }
            Pattern value = Pattern.compile(parts[1]);
            ServerTardisManager.getInstance().forEach(tardis -> {
                boolean matches = value.matcher((CharSequence)func.apply((ServerTardis)tardis)).matches();
                if (matches) {
                    ListCommand.sendTardis(source, tardis);
                }
            });
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.ait.list.pattern.error"));
            return 0;
        }
        return 1;
    }

    private static void sendTardis(class_2168 source, ServerTardis tardis) {
        source.method_45068((class_2561)class_2561.method_43470((String)"  - ").method_10852(TextUtil.forTardis(tardis)));
    }
}

