/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.PermissionArgumentType;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.permissions.Permission;
import dev.amble.ait.core.tardis.handler.permissions.PermissionHandler;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PermissionCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.permission", 2))).then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"permission", (ArgumentType)PermissionArgumentType.permission()).executes(PermissionCommand::get)).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PermissionCommand::set)))))));
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        CommonArgs args = CommonArgs.create(context);
        boolean value = BoolArgumentType.getBool(context, (String)"value");
        args.run("ait.command.permission.set", "Set permission '%s' for player %s to '%s'", handler -> handler.set(args.player, args.permission, value));
        return 1;
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        CommonArgs args = CommonArgs.create(context);
        return args.run("ait.command.permission.get", "Permission check '%s' for player %s: '%s'", handler -> handler.check(args.player, args.permission)) ? 1 : 0;
    }

    record CommonArgs(class_2168 source, ServerTardis tardis, class_3222 player, Permission permission) {
        public static CommonArgs create(CommandContext<class_2168> context) throws CommandSyntaxException {
            ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
            class_3222 player = class_2186.method_9315(context, (String)"player");
            Permission permission = PermissionArgumentType.getPermission(context, "permission");
            return new CommonArgs((class_2168)context.getSource(), tardis, player, permission);
        }

        public boolean run(String key, String fallback, Predicate<PermissionHandler> func) {
            boolean result = func.test(this.tardis.permissions());
            this.source.method_9226(() -> class_2561.method_48322((String)key, (String)fallback, (Object[])new Object[]{this.permission, this.player.method_5477(), result}), false);
            return result;
        }
    }
}

