/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class SetRepairTicksCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"repair").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.repair", 2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)TardisCrashHandler.MAX_REPAIR_TICKS)).executes(SetRepairTicksCommand::runCommand))))));
    }

    private static int runCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        if (tardis.crash().getRepairTicks() >= TardisCrashHandler.MAX_REPAIR_TICKS) {
            source.method_45068((class_2561)class_2561.method_48321((String)"tardis.repair.max", (String)"TARDIS repair ticks are at max!"));
            return 0;
        }
        int repairTicksAmount = IntegerArgumentType.getInteger(context, (String)"ticks");
        tardis.crash().setRepairTicks(repairTicksAmount);
        source.method_45068((class_2561)class_2561.method_48322((String)"tardis.repair.set", (String)"Set repair ticks for [%s] to: [%s]", (Object[])new Object[]{tardis.getUuid(), tardis.crash().getRepairTicks()}));
        return 1;
    }
}

