/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.util.TardisUtil;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

public final class TeleportInteriorCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.teleport", 2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"interior").executes(TeleportInteriorCommand::tpSelfInterior)).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9308()).executes(TeleportInteriorCommand::tpToInterior)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"exterior").executes(TeleportInteriorCommand::tpSelfExterior)).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9308()).executes(TeleportInteriorCommand::tpToExterior))))));
    }

    private static int tpSelfInterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 source = ((class_2168)context.getSource()).method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        return TeleportInteriorCommand.tpToInterior(tardis, Collections.singleton(source));
    }

    private static int tpSelfExterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 source = ((class_2168)context.getSource()).method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        return TeleportInteriorCommand.tpToExterior(tardis, Collections.singleton(source));
    }

    private static int tpToInterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 source = ((class_2168)context.getSource()).method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Collection entities = class_2186.method_9317(context, (String)"entities");
        return TeleportInteriorCommand.tpToInterior(tardis, source, entities);
    }

    private static int tpToExterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 source = ((class_2168)context.getSource()).method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Collection entities = class_2186.method_9317(context, (String)"entities");
        return TeleportInteriorCommand.tpToExterior(tardis, source, entities);
    }

    private static int tpToInterior(ServerTardis tardis, class_1297 source, Collection<? extends class_1297> players) {
        for (class_1297 class_12972 : players) {
            TardisUtil.teleportInside(tardis, class_12972);
        }
        source.method_43496((class_2561)class_2561.method_48321((String)"tardis.teleport.interior.success", (String)("Successful teleport - interior of [" + tardis.getUuid().toString().substring(0, 7) + "]")));
        return 1;
    }

    private static int tpToExterior(ServerTardis tardis, class_1297 source, Collection<? extends class_1297> players) {
        for (class_1297 class_12972 : players) {
            TardisUtil.teleportOutside(tardis, class_12972);
        }
        source.method_43496((class_2561)class_2561.method_48321((String)"tardis.teleport.exterior.success", (String)("Successful teleport - exterior of [" + tardis.getUuid().toString().substring(0, 7) + "]")));
        return 1;
    }

    private static int tpToInterior(ServerTardis tardis, Collection<? extends class_1297> players) {
        if (players.isEmpty()) {
            return 0;
        }
        return TeleportInteriorCommand.tpToInterior(tardis, players.stream().findFirst().get(), players);
    }

    private static int tpToExterior(ServerTardis tardis, Collection<? extends class_1297> players) {
        if (players.isEmpty()) {
            return 0;
        }
        return TeleportInteriorCommand.tpToExterior(tardis, players.stream().findFirst().get(), players);
    }
}

