/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.IdentifierWildcardArgumentType;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.data.Wildcard;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.register.unlockable.Unlockable;
import dev.amble.lib.register.unlockable.UnlockableRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class UnlockCommand {
    public static final SuggestionProvider<class_2168> CONSOLE_SUGGESTION = (context, builder) -> IdentifierWildcardArgumentType.suggestWildcardIds(builder, ConsoleVariantRegistry.getInstance());
    public static final SuggestionProvider<class_2168> DESKTOP_SUGGESTION = (context, builder) -> IdentifierWildcardArgumentType.suggestWildcardIds(builder, DesktopRegistry.getInstance());
    public static final SuggestionProvider<class_2168> EXTERIOR_SUGGESTION = (context, builder) -> IdentifierWildcardArgumentType.suggestWildcardIds(builder, ExteriorVariantRegistry.getInstance());

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ait").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlock").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.unlock", 2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"tardis", (ArgumentType)TardisArgumentType.tardis()).then(class_2170.method_9247((String)"console").then(class_2170.method_9244((String)"console", (ArgumentType)IdentifierWildcardArgumentType.wildcard()).suggests(CONSOLE_SUGGESTION).executes(UnlockCommand::unlockConsole)))).then(class_2170.method_9247((String)"desktop").then(class_2170.method_9244((String)"desktop", (ArgumentType)IdentifierWildcardArgumentType.wildcard()).suggests(DESKTOP_SUGGESTION).executes(UnlockCommand::unlockDesktop)))).then(class_2170.method_9247((String)"exterior").then(class_2170.method_9244((String)"exterior", (ArgumentType)IdentifierWildcardArgumentType.wildcard()).suggests(EXTERIOR_SUGGESTION).executes(UnlockCommand::unlockExterior))))));
    }

    private static <T extends Identifiable & Unlockable> int unlock(CommandContext<class_2168> context, String type, Wildcard<T> wildcard, UnlockableRegistry<T> registry) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        if (wildcard.isPresent()) {
            Identifiable t = (Identifiable)wildcard.get();
            source.method_9211().execute(() -> tardis.stats().unlock((Unlockable)t));
            source.method_45068((class_2561)class_2561.method_48322((String)"command.ait.unlock.some", (String)"Granted [%s] %s %s", (Object[])new Object[]{tardis.getUuid(), ((Nameable)t).name(), type}));
            return 1;
        }
        source.method_9211().execute(() -> registry.unlockAll(tardis));
        source.method_45068((class_2561)class_2561.method_48322((String)"command.ait.unlock.all", (String)"Granted [%s] every %s", (Object[])new Object[]{tardis.getUuid(), type}));
        return 1;
    }

    private static int unlockConsole(CommandContext<class_2168> context) throws CommandSyntaxException {
        return UnlockCommand.unlock(context, "console", IdentifierWildcardArgumentType.getConsoleVariantArgument(context, "console"), ConsoleVariantRegistry.getInstance());
    }

    private static int unlockDesktop(CommandContext<class_2168> context) throws CommandSyntaxException {
        return UnlockCommand.unlock(context, "desktop", IdentifierWildcardArgumentType.getDesktopArgument(context, "desktop"), DesktopRegistry.getInstance());
    }

    private static int unlockExterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        return UnlockCommand.unlock(context, "exterior variant", IdentifierWildcardArgumentType.getExteriorVariantArgument(context, "exterior"), ExteriorVariantRegistry.getInstance());
    }
}

