/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.world.TardisServerWorld;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3965;

public class TardisArgumentType
implements ArgumentType<ServerTardisAccessor> {
    public static final SimpleCommandExceptionType INVALID_UUID = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.uuid.invalid"));
    private static final Collection<String> EXAMPLES = List.of("~", "^", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    private static final Pattern VALID_CHARACTERS = Pattern.compile("^([-A-Fa-f0-9]+)");

    public static ServerTardis getTardis(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        return ((ServerTardisAccessor)context.getArgument(name, ServerTardisAccessor.class)).get(context);
    }

    public static TardisArgumentType tardis() {
        return new TardisArgumentType();
    }

    public ServerTardisAccessor parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '~') {
            reader.skip();
            return context -> {
                class_3218 patt0$temp = ((class_2168)context.getSource()).method_9225();
                if (!(patt0$temp instanceof TardisServerWorld)) {
                    throw INVALID_UUID.create();
                }
                TardisServerWorld tardisWorld = (TardisServerWorld)patt0$temp;
                return tardisWorld.getTardis();
            };
        }
        if (reader.canRead() && reader.peek() == '^') {
            reader.skip();
            return context -> {
                class_239 hit = ((class_2168)context.getSource()).method_9228().method_5745(16.0, 0.0f, false);
                if (!(hit instanceof class_3965)) {
                    throw INVALID_UUID.create();
                }
                class_3965 blockHit = (class_3965)hit;
                class_2586 blockEntity = ((class_2168)context.getSource()).method_9225().method_8321(blockHit.method_17777());
                if (!(blockEntity instanceof AbstractLinkableBlockEntity)) {
                    throw INVALID_UUID.create();
                }
                AbstractLinkableBlockEntity linkable = (AbstractLinkableBlockEntity)blockEntity;
                return linkable.tardis().get().asServer();
            };
        }
        String string = reader.getRemaining();
        Matcher matcher = VALID_CHARACTERS.matcher(string);
        if (!matcher.find()) {
            throw INVALID_UUID.create();
        }
        String raw = matcher.group(1);
        UUID uuid = UUID.fromString(raw);
        reader.setCursor(reader.getCursor() + raw.length());
        return context -> ServerTardisManager.getInstance().demandTardis(((class_2168)context.getSource()).method_9211(), uuid);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        boolean isServer = context.getSource() instanceof class_2168;
        TardisManager<?, ?> manager = TardisManager.getInstance(isServer);
        return class_2172.method_9264(manager.ids().stream().map(UUID::toString), (SuggestionsBuilder)builder.suggest("~").suggest("^"));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface ServerTardisAccessor {
        public ServerTardis get(CommandContext<class_2168> var1) throws CommandSyntaxException;
    }
}

