/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.commands.argument.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.regex.Pattern;
import net.minecraft.class_2561;

public class StringJsonReader {
    public static final SimpleCommandExceptionType TRAILING = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.nbt.trailing"));
    public static final SimpleCommandExceptionType EXPECTED_KEY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType EXPECTED_VALUE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.nbt.expected.value"));
    public static final char COMMA = ',';
    public static final char COLON = ':';
    public static final char SEMICOLON = ';';
    private static final char SQUARE_OPEN_BRACKET = '[';
    private static final char SQUARE_CLOSE_BRACKET = ']';
    private static final char RIGHT_CURLY_BRACKET = '}';
    private static final char LEFT_CURLY_BRACKET = '{';
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final StringReader reader;

    public static JsonObject parse(String string) throws CommandSyntaxException {
        return new StringJsonReader(new StringReader(string)).readCompound();
    }

    JsonObject readCompound() throws CommandSyntaxException {
        JsonObject nbtCompound = this.parseObject();
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw TRAILING.createWithContext((ImmutableStringReader)this.reader);
        }
        return nbtCompound;
    }

    public StringJsonReader(StringReader reader) {
        this.reader = reader;
    }

    protected String readString() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.reader.readString();
    }

    protected JsonPrimitive parseElementPrimitive() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        int i = this.reader.getCursor();
        if (StringReader.isQuotedStringStart((char)this.reader.peek())) {
            return new JsonPrimitive(this.reader.readQuotedString());
        }
        String string = this.reader.readUnquotedString();
        if (string.isEmpty()) {
            this.reader.setCursor(i);
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.parsePrimitive(string);
    }

    private JsonPrimitive parsePrimitive(String input) {
        try {
            if (FLOAT_PATTERN.matcher(input).matches()) {
                return new JsonPrimitive((Number)Float.valueOf(Float.parseFloat(input.substring(0, input.length() - 1))));
            }
            if (INT_PATTERN.matcher(input).matches()) {
                return new JsonPrimitive((Number)Integer.parseInt(input));
            }
            if ("true".equalsIgnoreCase(input)) {
                return new JsonPrimitive(Boolean.valueOf(true));
            }
            if ("false".equalsIgnoreCase(input)) {
                return new JsonPrimitive(Boolean.valueOf(false));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new JsonPrimitive(input);
    }

    public JsonElement parseElement() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        char c = this.reader.peek();
        if (c == '{') {
            return this.parseObject();
        }
        if (c == '[') {
            return this.parseArray();
        }
        return this.parseElementPrimitive();
    }

    protected JsonArray parseArray() throws CommandSyntaxException {
        if (this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';') {
            return this.parseElementPrimitiveArray();
        }
        return this.parseList();
    }

    public JsonObject parseObject() throws CommandSyntaxException {
        this.expect('{');
        JsonObject jsonObject = new JsonObject();
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != '}') {
            int i = this.reader.getCursor();
            String string = this.readString();
            if (string.isEmpty()) {
                this.reader.setCursor(i);
                throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
            }
            this.expect(':');
            jsonObject.add(string, this.parseElement());
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect('}');
        return jsonObject;
    }

    private JsonArray parseList() throws CommandSyntaxException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        JsonArray nbtList = new JsonArray();
        while (this.reader.peek() != ']') {
            nbtList.add(this.parseElement());
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return nbtList;
    }

    private JsonArray parseElementPrimitiveArray() throws CommandSyntaxException {
        this.expect('[');
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.readNumberArray();
    }

    private JsonArray readNumberArray() throws CommandSyntaxException {
        JsonArray list = new JsonArray();
        while (this.reader.peek() != ']') {
            JsonElement jsonElement = this.parseElement();
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                list.add(primitive.getAsNumber());
            }
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return list;
    }

    private boolean readComma() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char c) throws CommandSyntaxException {
        this.reader.skipWhitespace();
        this.reader.expect(c);
    }
}

