/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.drinks;

import com.google.common.collect.ComparisonChain;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.lib.api.Identifiable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public record DatapackPotion(class_2960 id, int duration, int amplifier, Optional<Boolean> ambient, Optional<Boolean> showParticles, Optional<Boolean> showIcon) implements Identifiable,
Comparable<class_1293>
{
    public static final Codec<DatapackPotion> CODEC = class_5699.method_42114((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DatapackPotion::id), (App)Codec.INT.fieldOf("duration").forGetter(DatapackPotion::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(DatapackPotion::amplifier), (App)Codec.BOOL.optionalFieldOf("ambient").forGetter(DatapackPotion::ambient), (App)Codec.BOOL.optionalFieldOf("show_particles").forGetter(DatapackPotion::showParticles), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(DatapackPotion::showIcon)).apply((Applicative)instance, DatapackPotion::new)));

    public DatapackPotion(class_2960 id) {
        this(id, 0, 0, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public DatapackPotion(class_2960 id, int duration, int amplifier) {
        this(id, duration, amplifier, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public DatapackPotion(class_2960 id, int duration, int amplifier, boolean ambient) {
        this(id, duration, amplifier, Optional.of(ambient), Optional.empty(), Optional.empty());
    }

    public DatapackPotion(class_2960 id, int duration, int amplifier, boolean ambient, boolean showParticles) {
        this(id, duration, amplifier, Optional.of(ambient), Optional.of(showParticles), Optional.empty());
    }

    public DatapackPotion(class_2960 id, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        this(id, duration, amplifier, Optional.of(ambient), Optional.of(showParticles), Optional.of(showIcon));
    }

    public DatapackPotion(class_1291 statusEffect) {
        this(DatapackPotion.getEffect(statusEffect), 0, 0, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public DatapackPotion(class_1291 statusEffect, int duration, int amplifier) {
        this(DatapackPotion.getEffect(statusEffect), duration, amplifier, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public DatapackPotion(class_1291 statusEffect, int duration, int amplifier, boolean ambient) {
        this(DatapackPotion.getEffect(statusEffect), duration, amplifier, Optional.of(ambient), Optional.empty(), Optional.empty());
    }

    public DatapackPotion(class_1291 statusEffect, int duration, int amplifier, boolean ambient, boolean showParticles) {
        this(DatapackPotion.getEffect(statusEffect), duration, amplifier, Optional.of(ambient), Optional.of(showParticles), Optional.empty());
    }

    public DatapackPotion(class_1291 statusEffect, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        this(DatapackPotion.getEffect(statusEffect), duration, amplifier, Optional.of(ambient), Optional.of(showParticles), Optional.of(showIcon));
    }

    @Override
    public String toString() {
        return "DatapackPotion{id=" + String.valueOf(this.id) + "duration=" + this.duration + "amplifier=" + this.amplifier + "ambient=" + String.valueOf(this.ambient) + "show_particles=" + String.valueOf(this.showParticles) + "show_icon=" + String.valueOf(this.showIcon) + "}";
    }

    public static DatapackPotion fromInputStream(InputStream stream) {
        return DatapackPotion.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static DatapackPotion fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(var -> created.set((DatapackPotion)var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack potion: {}", err);
        });
        return (DatapackPotion)created.get();
    }

    @Override
    public int compareTo(class_1293 statusEffectInstance) {
        int i = 32147;
        if (this.getDuration() > 32147 && statusEffectInstance.method_5584() > 32147 || this.isAmbient() && statusEffectInstance.method_5591()) {
            return ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(statusEffectInstance.method_5591())).compare(this.getEffectType().method_5556(), statusEffectInstance.method_5579().method_5556()).result();
        }
        return ComparisonChain.start().compareFalseFirst(this.isAmbient(), statusEffectInstance.method_5591()).compareFalseFirst(this.isInfinite(), statusEffectInstance.method_48559()).compare(this.getDuration(), statusEffectInstance.method_5584()).compare(this.getEffectType().method_5556(), statusEffectInstance.method_5579().method_5556()).result();
    }

    public int getDuration() {
        return this.duration();
    }

    public boolean isInfinite() {
        return this.duration() >= 32147;
    }

    public int getAmplifier() {
        return this.amplifier();
    }

    public boolean isAmbient() {
        return this.ambient().orElse(false);
    }

    public class_1291 getEffectType() {
        return (class_1291)class_7923.field_41174.method_10223(this.id());
    }

    public static class_2960 getEffect(class_1291 statusEffect) {
        return class_7923.field_41174.method_10221((Object)statusEffect);
    }

    public class_1293 getInstance() {
        class_1291 effect1 = this.getEffectType();
        if (effect1 == null) {
            return null;
        }
        return new class_1293(effect1, this.duration(), this.amplifier(), this.ambient().orElse(false).booleanValue(), this.showParticles().orElse(true).booleanValue(), this.showIcon().orElse(false).booleanValue());
    }
}

