/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.drinks;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.drinks.DatapackPotion;
import dev.amble.ait.data.codec.MoreCodec;
import dev.amble.lib.api.Identifiable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.joml.Vector3f;

public record Drink(class_2960 id, Optional<Boolean> hasCustomColor, Optional<Vector3f> custom_color, List<DatapackPotion> potionInstances) implements Identifiable
{
    public static final Codec<Drink> CODEC = class_5699.method_42114((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(Drink::id), (App)Codec.BOOL.optionalFieldOf("has_custom_color").forGetter(Drink::hasCustomColor), (App)MoreCodec.VECTOR3F.optionalFieldOf("custom_color").forGetter(Drink::custom_color), (App)DatapackPotion.CODEC.listOf().fieldOf("potion_instances").forGetter(Drink::potionInstances)).apply((Applicative)instance, Drink::new)));

    public Vector3f getColor() {
        return this.custom_color().orElse(new Vector3f());
    }

    public boolean getHasColor() {
        return this.hasCustomColor().orElse(false);
    }

    public static Drink fromInputStream(InputStream stream) {
        return Drink.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static Drink fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(var -> created.set((Drink)var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack drink: {}", err);
        });
        return (Drink)created.get();
    }

    public Collection<class_1293> getEffects() {
        return this.potionInstances().stream().map(DatapackPotion::getInstance).collect(Collectors.toList());
    }
}

