/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.drinks;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.drinks.Drink;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.item.PersonalityMatrixItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DrinkUtil {
    public static final String CUSTOM_DRINK_EFFECTS_KEY = "CustomDrinkEffects";
    public static final String CUSTOM_DRINK_COLOR_KEY = "CustomDrinkColor";
    public static final String DRINK_KEY = "Drink";
    private static final int DEFAULT_COLOR = PersonalityMatrixItem.colorToInt(210, 227, 252);
    private static final class_2561 NONE_TEXT = class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080);
    public static final Drink EMPTY = DrinkRegistry.EMPTY_MUG;

    public static List<class_1293> getDrinkEffects(class_1799 stack) {
        return DrinkUtil.getDrinkEffects(stack.method_7969());
    }

    public static List<class_1293> getDrinkEffects(Drink drink, Collection<class_1293> custom) {
        ArrayList list = Lists.newArrayList();
        list.addAll(drink.getEffects());
        list.addAll(custom);
        return list;
    }

    public static List<class_1293> getDrinkEffects(class_2487 nbt) {
        ArrayList list = Lists.newArrayList();
        Drink drink = DrinkUtil.getDrink(nbt);
        if (drink == null) {
            return list;
        }
        list.addAll(DrinkUtil.getDrink(nbt).getEffects());
        DrinkUtil.getCustomDrinkEffects(nbt, list);
        return list;
    }

    public static List<class_1293> getCustomDrinkEffects(class_1799 stack) {
        return DrinkUtil.getCustomDrinkEffects(stack.method_7969());
    }

    public static List<class_1293> getCustomDrinkEffects(@Nullable class_2487 nbt) {
        ArrayList list = Lists.newArrayList();
        DrinkUtil.getCustomDrinkEffects(nbt, list);
        return list;
    }

    public static void getCustomDrinkEffects(@Nullable class_2487 nbt, List<class_1293> list) {
        if (nbt != null && nbt.method_10573(CUSTOM_DRINK_EFFECTS_KEY, 9)) {
            class_2499 nbtList = nbt.method_10554(CUSTOM_DRINK_EFFECTS_KEY, 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                class_1293 statusEffectInstance = class_1293.method_5583((class_2487)nbtCompound);
                if (statusEffectInstance == null) continue;
                list.add(statusEffectInstance);
            }
        }
    }

    public static int getColor(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(CUSTOM_DRINK_COLOR_KEY, 99)) {
            return nbtCompound.method_10550(CUSTOM_DRINK_COLOR_KEY);
        }
        Drink drink = DrinkUtil.getDrink(stack);
        return drink == null || Objects.equals(drink, EMPTY) ? DEFAULT_COLOR : DrinkUtil.getColor(drink, DrinkUtil.getDrinkEffects(stack));
    }

    public static int getColor(Drink drink, Collection<class_1293> effects) {
        if (drink.getHasColor()) {
            Vector3f vector = drink.getColor();
            return PersonalityMatrixItem.colorToInt((int)(vector.x() * 255.0f), (int)(vector.y() * 255.0f), (int)(vector.z() * 255.0f));
        }
        if (effects.isEmpty()) {
            return DEFAULT_COLOR;
        }
        float f = 0.0f;
        float g = 0.0f;
        float h = 0.0f;
        int j = 0;
        for (class_1293 statusEffectInstance : effects) {
            if (!statusEffectInstance.method_5581()) continue;
            int k = statusEffectInstance.method_5579().method_5556();
            int l = statusEffectInstance.method_5578() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            g += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            h += (float)(l * (k & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        g = g / (float)j * 255.0f;
        h = h / (float)j * 255.0f;
        return (int)f << 16 | (int)g << 8 | (int)h;
    }

    public static void applyEffects(class_1799 drinkStack, class_1309 user) {
        if (DrinkUtil.isMilk(DrinkUtil.getDrink(drinkStack))) {
            user.method_6012();
            return;
        }
        List<class_1293> list = DrinkUtil.getDrinkEffects(drinkStack);
        for (class_1293 statusEffectInstance : list) {
            if (statusEffectInstance.method_5579().method_5561()) {
                statusEffectInstance.method_5579().method_5564(null, null, user, statusEffectInstance.method_5578(), 1.0);
                continue;
            }
            user.method_6092(new class_1293(statusEffectInstance));
        }
    }

    private static boolean isMilk(Drink drink) {
        return ((Drink)DrinkRegistry.getInstance().getOrFallback(AITMod.id("milk"))).equals(drink);
    }

    public static Drink getDrink(class_1799 stack) {
        return DrinkUtil.getDrink(stack.method_7969());
    }

    public static Drink getDrink(@Nullable class_2487 compound) {
        if (compound == null) {
            return EMPTY;
        }
        return (Drink)DrinkRegistry.getInstance().get(class_2960.method_12829((String)compound.method_10558(DRINK_KEY)));
    }

    public static class_1799 setDrink(class_1799 stack, Drink drink) {
        if (drink == null || drink == EMPTY) {
            stack.method_7983(DRINK_KEY);
        } else {
            stack.method_7948().method_10582(DRINK_KEY, drink.id().toString());
        }
        return stack;
    }

    public static class_1799 setCustomDrinkEffects(class_1799 stack, Collection<class_1293> effects) {
        if (effects.isEmpty()) {
            return stack;
        }
        class_2487 nbtCompound = stack.method_7948();
        class_2499 nbtList = nbtCompound.method_10554(CUSTOM_DRINK_EFFECTS_KEY, 9);
        for (class_1293 statusEffectInstance : effects) {
            nbtList.add((Object)statusEffectInstance.method_5582(new class_2487()));
        }
        nbtCompound.method_10566(CUSTOM_DRINK_EFFECTS_KEY, (class_2520)nbtList);
        return stack;
    }

    public static void buildTooltip(class_1799 stack, List<class_2561> list, float durationMultiplier) {
        DrinkUtil.buildTooltip(DrinkUtil.getDrinkEffects(stack), list, durationMultiplier);
    }

    public static void buildTooltip(List<class_1293> statusEffects, List<class_2561> list, float durationMultiplier) {
        ArrayList list2 = Lists.newArrayList();
        if (statusEffects.isEmpty()) {
            list.add(NONE_TEXT);
        } else {
            for (class_1293 statusEffectInstance : statusEffects) {
                class_5250 mutableText = statusEffectInstance.method_5586() == null ? class_2561.method_43473() : class_2561.method_43471((String)statusEffectInstance.method_5586());
                class_1291 statusEffect = statusEffectInstance.method_5579();
                Map map = statusEffect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        class_1322 entityAttributeModifier = (class_1322)entry.getValue();
                        class_1322 entityAttributeModifier2 = new class_1322(entityAttributeModifier.method_6185(), statusEffect.method_5563(statusEffectInstance.method_5578(), entityAttributeModifier), entityAttributeModifier.method_6182());
                        list2.add(new Pair((Object)((class_1320)entry.getKey()), (Object)entityAttributeModifier2));
                    }
                }
                if (statusEffectInstance.method_5578() > 0) {
                    mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + statusEffectInstance.method_5578()))});
                }
                if (!statusEffectInstance.method_48557(20)) {
                    mutableText = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableText, class_1292.method_5577((class_1293)statusEffectInstance, (float)durationMultiplier)});
                }
                list.add((class_2561)mutableText.method_27692(statusEffect.method_18792().method_18793()));
            }
        }
        if (!list2.isEmpty()) {
            list.add(class_5244.field_39003);
            list.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : list2) {
                double e;
                class_1322 entityAttributeModifier3 = (class_1322)pair.getSecond();
                double d = entityAttributeModifier3.method_6186();
                double d2 = e = entityAttributeModifier3.method_6182() == class_1322.class_1323.field_6330 || entityAttributeModifier3.method_6182() == class_1322.class_1323.field_6331 ? entityAttributeModifier3.method_6186() * 100.0 : entityAttributeModifier3.method_6186();
                if (d > 0.0) {
                    list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + entityAttributeModifier3.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(e), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d < 0.0)) continue;
                list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + entityAttributeModifier3.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(e *= -1.0), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }
}

