/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.api.tardis.Initializable;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.engine.StructureHolder;
import dev.amble.ait.core.engine.impl.ChameleonCircuit;
import dev.amble.ait.core.engine.impl.DematCircuit;
import dev.amble.ait.core.engine.impl.DesperationCircuit;
import dev.amble.ait.core.engine.impl.EmergencyPower;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.engine.impl.GravitationalCircuit;
import dev.amble.ait.core.engine.impl.LifeSupportCircuit;
import dev.amble.ait.core.engine.impl.ShieldsCircuit;
import dev.amble.ait.core.engine.impl.Stabilisers;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.enummap.Ordered;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class SubSystem
extends Initializable<InitContext>
implements Disposable {
    @Exclude
    protected Tardis tardis;
    @Exclude(strategy=Exclude.Strategy.NETWORK)
    private final IdLike id;
    private boolean enabled = false;
    private boolean isReal = false;

    protected SubSystem(IdLike id) {
        this.id = id;
    }

    public abstract class_1792 asItem();

    public IdLike getId() {
        return this.id;
    }

    public Tardis tardis() {
        return this.tardis;
    }

    public class_2561 name() {
        return class_2561.method_43471((String)this.getId().toTranslationKey());
    }

    public void setTardis(Tardis tardis) {
        this.tardis = tardis;
    }

    public boolean isClient() {
        return !this.isServer();
    }

    public boolean isServer() {
        return this.tardis() instanceof ServerTardis;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public boolean isUsable() {
        return this.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.onEnable();
        } else {
            this.onDisable();
        }
    }

    protected void onEnable() {
        if (!this.isReal) {
            this.isReal = true;
        }
        ((TardisEvents.OnSubSystemEnable)TardisEvents.SUBSYSTEM_ENABLE.invoker()).onEnable(this);
    }

    protected void onDisable() {
        ((TardisEvents.OnSubSystemDisable)TardisEvents.SUBSYSTEM_DISABLE.invoker()).onDisable(this);
    }

    public void tick() {
    }

    public List<class_1799> toStacks() {
        StructureHolder holder;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        SubSystem subSystem = this;
        if (subSystem instanceof StructureHolder && (holder = (StructureHolder)((Object)subSystem)).getStructure() != null && !holder.getStructure().isEmpty()) {
            stacks.addAll(holder.getStructure().toStacks());
        }
        stacks.add(this.asItem().method_7854());
        stacks.add(AITBlocks.GENERIC_SUBSYSTEM.method_8389().method_7854());
        return stacks;
    }

    protected void sync() {
        ServerTardisManager.getInstance().markComponentDirty(this.tardis.subsystems());
    }

    @Override
    public void dispose() {
        this.tardis = null;
    }

    public static void init(SubSystem system, Tardis tardis, TardisComponent.InitContext context) {
        if (system == null) {
            return;
        }
        system.setTardis(tardis);
        Initializable.init(system, InitContext.fromTardisContext(context));
    }

    public static Object serializer() {
        return new Adapter();
    }

    public static interface IdLike
    extends Ordered {
        default public void set(ClientTardis tardis, SubSystem component) {
            tardis.subsystems().add(component);
        }

        default public SubSystem get(ClientTardis tardis) {
            return tardis.subsystems().get(this);
        }

        public Class<? extends SubSystem> clazz();

        public SubSystem create();

        public boolean creatable();

        public String name();

        @Override
        public int index();

        public void index(int var1);

        default public String toTranslationKey() {
            return "subsystem.ait." + this.name().toLowerCase();
        }
    }

    public record InitContext(@Nullable CachedDirectedGlobalPos pos, boolean deserialized) implements Initializable.Context
    {
        public static InitContext createdAt(CachedDirectedGlobalPos pos) {
            return new InitContext(pos, false);
        }

        public static InitContext deserialize() {
            return new InitContext(null, true);
        }

        public static InitContext fromTardisContext(TardisComponent.InitContext context) {
            return new InitContext(context.pos(), context.deserialized());
        }

        @Override
        public boolean created() {
            return !this.deserialized;
        }
    }

    private static class Adapter
    implements JsonSerializer<SubSystem>,
    JsonDeserializer<SubSystem> {
        private Adapter() {
        }

        public SubSystem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            IdLike id = (IdLike)context.deserialize(jsonObject.get("id"), IdLike.class);
            JsonElement element = jsonObject.get("data");
            return (SubSystem)context.deserialize(element, id.clazz());
        }

        public JsonElement serialize(SubSystem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.add("id", context.serialize((Object)src.getId()));
            result.add("data", context.serialize((Object)src, src.getClass()));
            return result;
        }
    }

    public static enum Id implements IdLike
    {
        ENGINE(EngineSystem.class, EngineSystem::new),
        DEMAT(DematCircuit.class, DematCircuit::new),
        LIFE_SUPPORT(LifeSupportCircuit.class, LifeSupportCircuit::new),
        SHIELDS(ShieldsCircuit.class, ShieldsCircuit::new),
        DESPERATION(DesperationCircuit.class, DesperationCircuit::new),
        CHAMELEON(ChameleonCircuit.class, ChameleonCircuit::new),
        EMERGENCY_POWER(EmergencyPower.class, EmergencyPower::new),
        STABILISERS(Stabilisers.class, Stabilisers::new),
        GRAVITATIONAL(GravitationalCircuit.class, GravitationalCircuit::new);

        private final Supplier<SubSystem> creator;
        private final Class<? extends SubSystem> clazz;
        private Integer index = null;

        private <T extends SubSystem> Id(Class<T> clazz, Supplier<T> creator) {
            this.clazz = clazz;
            this.creator = creator;
        }

        @Override
        public Class<? extends SubSystem> clazz() {
            return this.clazz;
        }

        @Override
        public SubSystem create() {
            return this.creator.get();
        }

        @Override
        public boolean creatable() {
            return this.creator != null;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void index(int i) {
            this.index = i;
        }

        public static IdLike[] ids() {
            return Id.values();
        }
    }
}

