/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.block;

import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.SubSystemBlock;
import dev.amble.ait.core.engine.link.block.FluidLinkBlockEntity;
import dev.amble.ait.core.engine.registry.SubSystemRegistry;
import dev.amble.ait.core.util.SoundData;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3419;

public class SubSystemBlockEntity
extends FluidLinkBlockEntity {
    protected SubSystem.IdLike id;

    public SubSystemBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, SubSystem.IdLike id) {
        super(type, pos, state);
        this.id = id;
    }

    public SubSystem system() {
        if (!this.isLinked() || this.id() == null) {
            return null;
        }
        return this.tardis().get().subsystems().get(this.id());
    }

    protected SubSystem.IdLike id() {
        if (this.id == null) {
            this.id = ((SubSystemBlock)this.method_11010().method_26204()).getSystemId();
        }
        return this.id;
    }

    @Override
    public void onGainFluid() {
        DurableSubSystem durable;
        super.onGainFluid();
        if (this.system() == null) {
            return;
        }
        SubSystem subSystem = this.system();
        if (subSystem instanceof DurableSubSystem && (durable = (DurableSubSystem)subSystem).isBroken()) {
            return;
        }
        this.system().setEnabled(true);
    }

    @Override
    public void onLoseFluid() {
        super.onLoseFluid();
        if (this.system() == null) {
            return;
        }
        this.system().setEnabled(false);
    }

    @Override
    protected SoundData getGainPowerSound() {
        return new SoundData(AITSounds.SIEGE_DISABLE, class_3419.field_15245, 0.25f, 1.0f);
    }

    @Override
    protected SoundData getLosePowerSound() {
        return new SoundData(AITSounds.SIEGE_ENABLE, class_3419.field_15245, 0.25f, 1.0f);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
    }

    public class_1269 useOn(class_2680 state, class_1937 world, boolean sneaking, class_1657 player, class_1799 hand) {
        DurableSubSystem durable;
        SubSystem subSystem = this.system();
        if (subSystem instanceof DurableSubSystem && (durable = (DurableSubSystem)subSystem).isRepairItem(hand) && durable.durability() < 1250.0f) {
            durable.addDurability(50.0f);
            hand.method_7934(1);
            world.method_8396(null, this.method_11016(), AITSounds.ENGINE_REFUEL, class_3419.field_15245, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.id != null) {
            nbt.method_10582("SystemId", this.id.name());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("SystemId")) {
            this.id = SubSystemRegistry.getInstance().get(nbt.method_10558("SystemId"));
        }
    }
}

