/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.block.generic;

import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.StructureHolder;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.multi.MultiBlockStructure;
import dev.amble.ait.core.engine.block.multi.StructureSystemBlockEntity;
import dev.amble.ait.core.engine.item.SubSystemItem;
import dev.amble.ait.core.util.StackUtil;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class GenericStructureSystemBlockEntity
extends StructureSystemBlockEntity {
    private class_1799 idSource;

    protected GenericStructureSystemBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, null);
    }

    public GenericStructureSystemBlockEntity(class_2338 pos, class_2680 state) {
        this(AITBlockEntityTypes.GENERIC_SUBSYSTEM_BLOCK_TYPE, pos, state);
    }

    @Override
    public class_1269 useOn(class_2680 state, class_1937 world, boolean sneaking, class_1657 player, class_1799 hand) {
        if (hand.method_7960() && this.system() != null && this.idSource != null) {
            DurableSubSystem durable;
            SubSystem subSystem = this.system();
            if (subSystem instanceof DurableSubSystem && ((durable = (DurableSubSystem)subSystem).isBroken() || durable.durability() < 1250.0f)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.engine.system_is_weakened"), true);
                return class_1269.field_5812;
            }
            StackUtil.spawn(world, this.field_11867, this.idSource.method_51164());
            if (this.tardis().isPresent() && this.id() != null) {
                this.system().setEnabled(false);
            }
            world.method_8396(null, this.method_11016(), AITSounds.WAYPOINT_ACTIVATE, class_3419.field_15245, 1.0f, 0.1f);
            this.method_5431();
            this.id = null;
            return class_1269.field_5812;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        class_1792 class_17922 = hand.method_7909();
        if (class_17922 instanceof SubSystemItem) {
            SubSystemItem link = (SubSystemItem)class_17922;
            if (this.system() != null && this.idSource != null) {
                if (this.tardis() != null) {
                    this.system().setEnabled(false);
                }
                StackUtil.spawn(world, this.field_11867, this.idSource.method_51164());
            }
            this.setId(link.id());
            this.idSource = hand.method_7972();
            this.idSource.method_7939(1);
            hand.method_7934(1);
            world.method_8396(null, this.method_11016(), AITSounds.WAYPOINT_ACTIVATE, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.useOn(state, world, sneaking, player, hand);
    }

    private void setId(SubSystem.IdLike id) {
        this.id = id;
        this.onChangeId();
    }

    protected StructureHolder getHolder() {
        SubSystem subSystem = this.system();
        if (!(subSystem instanceof StructureHolder)) {
            return null;
        }
        StructureHolder holder = (StructureHolder)((Object)subSystem);
        return holder;
    }

    protected void onChangeId() {
        this.processStructure();
        this.method_5431();
        this.sync();
    }

    public boolean hasSystem() {
        return this.id() != null;
    }

    @Override
    protected MultiBlockStructure getStructure() {
        StructureHolder holder = this.getHolder();
        if (holder == null) {
            return null;
        }
        return holder.getStructure();
    }

    @Override
    public boolean isStructureComplete(class_1937 world, class_2338 pos) {
        if (this.getStructure() == null) {
            return false;
        }
        return super.isStructureComplete(world, pos);
    }

    @Override
    protected boolean shouldRefresh(class_3218 world, class_2338 pos) {
        if (this.getStructure() == null) {
            return false;
        }
        return super.shouldRefresh(world, pos);
    }

    @Override
    public void onLoseFluid() {
        if (this.system() == null) {
            return;
        }
        super.onLoseFluid();
    }

    @Override
    public void onBroken(class_1937 world, class_2338 pos) {
        super.onBroken(world, pos);
        if (world.method_8608() || this.idSource == null) {
            return;
        }
        StackUtil.spawn(world, pos, this.idSource.method_51164());
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.idSource != null) {
            nbt.method_10566("SourceStack", (class_2520)this.idSource.method_7953(new class_2487()));
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("SourceStack")) {
            this.idSource = class_1799.method_7915((class_2487)nbt.method_10562("SourceStack"));
        }
    }

    public Optional<class_1799> getSourceStack() {
        return Optional.ofNullable(this.idSource);
    }
}

