/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.block.multi;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.mixin.server.structure.StructureTemplateAccessor;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3499;

public class MultiBlockStructure
extends ArrayList<BlockOffset> {
    public static final MultiBlockStructure EMPTY = new MultiBlockStructure(new BlockOffset[0]);

    public MultiBlockStructure(BlockOffset ... offsets) {
        this(List.of(offsets));
    }

    public MultiBlockStructure(List<BlockOffset> offsets) {
        super(offsets);
    }

    public boolean check(class_1937 world, class_2338 center) {
        return MultiBlockStructure.check(world, center, this, AITMod.LOGGER.isDebugEnabled());
    }

    public static boolean check(class_1937 world, class_2338 center, List<BlockOffset> blockOffsets, boolean log) {
        for (BlockOffset blockOffset : blockOffsets) {
            class_2338 targetPos = center.method_10081((class_2382)blockOffset.offset);
            if (blockOffset.block.contains(world.method_8320(targetPos))) continue;
            if (log) {
                AITMod.LOGGER.error("{} is not {} but {} for {}", new Object[]{targetPos, blockOffset.block, world.method_8320(targetPos), blockOffsets});
            }
            return false;
        }
        return true;
    }

    public MultiBlockStructure offset(class_2338 offset) {
        ArrayList<BlockOffset> newOffsets = new ArrayList<BlockOffset>();
        for (BlockOffset blockOffset : this) {
            newOffsets.add(blockOffset.offset(offset));
        }
        return new MultiBlockStructure((List<BlockOffset>)newOffsets);
    }

    public MultiBlockStructure offset(int x, int y, int z) {
        return this.offset(new class_2338(x, y, z));
    }

    public Optional<BlockOffset> remove(class_2338 pos) {
        Optional<BlockOffset> found = this.at(pos);
        found.ifPresent(this::remove);
        return found;
    }

    public Optional<BlockOffset> at(class_2338 pos) {
        return this.stream().filter(blockOffset -> blockOffset.offset.equals((Object)pos)).findFirst();
    }

    public BlockOffset atOrDefault(class_2338 pos, BlockOffset def) {
        return this.at(pos).orElse(def);
    }

    public Optional<BlockOffset> put(BlockOffset offset) {
        Optional<BlockOffset> prev = this.remove(offset.offset);
        this.add(offset);
        return prev;
    }

    public List<class_1799> toStacks() {
        class_1277 inv = new class_1277(256);
        for (BlockOffset blockOffset : this) {
            for (class_1799 stack : blockOffset.toStacks()) {
                inv.method_5491(stack);
            }
        }
        return inv.method_24514();
    }

    public static MultiBlockStructure testInteriorRendering(class_2960 structure) {
        if (!ServerLifecycleHooks.isServer()) {
            AITMod.LOGGER.error("Attempted to load multiblock structure on client side");
            return EMPTY;
        }
        class_3499 template = WorldUtil.getOverworld().method_14183().method_15094(structure).orElse(null);
        if (template == null) {
            AITMod.LOGGER.error("Failed to find structure template {}", (Object)structure);
            return EMPTY;
        }
        List list = ((StructureTemplateAccessor)template).getBlockInfo().get(0).method_27125();
        class_2338 center = list.stream().filter(info -> info.comp_1342().method_27852(AITBlocks.DOOR_BLOCK)).map(class_3499.class_3501::comp_1341).findFirst().orElse(null);
        if (center == null) {
            AITMod.LOGGER.error("No general subsystem block found in template, {}", (Object)structure);
            return EMPTY;
        }
        MultiBlockStructure created = new MultiBlockStructure(new BlockOffset[0]);
        list.stream().filter(info -> !info.comp_1342().method_27852(AITBlocks.DOOR_BLOCK) && !info.comp_1342().method_26215()).map(info -> new BlockOffset(new AllowedBlocks(info.comp_1342().method_26204()), info.comp_1341().method_10059((class_2382)center))).forEach(created::add);
        return created;
    }

    public static MultiBlockStructure from(class_2960 structure) {
        if (!ServerLifecycleHooks.isServer()) {
            AITMod.LOGGER.error("Attempted to load multiblock structure on client side");
            return EMPTY;
        }
        class_3499 template = WorldUtil.getOverworld().method_14183().method_15094(structure).orElse(null);
        MultiBlockStructure created = new MultiBlockStructure(new BlockOffset[0]);
        if (template == null) {
            AITMod.LOGGER.error("Failed to find structure template {}", (Object)structure);
            return created;
        }
        List list = ((StructureTemplateAccessor)template).getBlockInfo().get(0).method_27125();
        class_2338 center = null;
        for (class_3499.class_3501 info : list) {
            if (!info.comp_1342().method_27852(AITBlocks.GENERIC_SUBSYSTEM)) continue;
            center = info.comp_1341();
            break;
        }
        if (center == null) {
            AITMod.LOGGER.error("No general subsystem block found in template, {}", (Object)structure);
            return created;
        }
        for (class_3499.class_3501 info : list) {
            if (info.comp_1342().method_27852(AITBlocks.GENERIC_SUBSYSTEM) || info.comp_1342().method_26215()) continue;
            class_2338 offset = info.comp_1341().method_10059((class_2382)center);
            BlockOffset blockOffset = new BlockOffset(new AllowedBlocks(info.comp_1342().method_26204()), offset);
            created.add(blockOffset);
        }
        AITMod.LOGGER.info("Loaded multiblock structure {} with {} blocks", (Object)structure, (Object)created.size());
        return created;
    }

    public record BlockOffset(AllowedBlocks block, class_2338 offset) {
        public BlockOffset(class_2248 block, int x, int y, int z) {
            this(new AllowedBlocks(block), new class_2338(x, y, z));
        }

        public BlockOffset(class_2248 block) {
            this(new AllowedBlocks(block), class_2338.field_10980);
        }

        public BlockOffset offset(int x, int y, int z) {
            return new BlockOffset(this.block, this.offset.method_10069(x, y, z));
        }

        public BlockOffset offset(class_2338 offset) {
            return new BlockOffset(this.block, this.offset.method_10081((class_2382)offset));
        }

        public BlockOffset allow(class_2248 ... blocks) {
            this.block.addAll(List.of(blocks));
            return this;
        }

        @Override
        public String toString() {
            return "BlockOffset{block=" + String.valueOf(this.block) + ", offset=" + String.valueOf(this.offset) + "}";
        }

        public List<class_1799> toStacks() {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_2248 block : this.block) {
                stacks.add(new class_1799((class_1935)block));
            }
            return stacks;
        }

        public static List<BlockOffset> corners(class_2248 block, int x, int y, int z) {
            return List.of(new BlockOffset(block, x, y, z), new BlockOffset(block, -x, y, z), new BlockOffset(block, x, -y, z), new BlockOffset(block, x, y, -z), new BlockOffset(block, -x, -y, z), new BlockOffset(block, x, -y, -z), new BlockOffset(block, -x, y, -z), new BlockOffset(block, -x, -y, -z));
        }

        public static List<BlockOffset> volume(class_2248 block, int width, int height, int depth) {
            ArrayList<BlockOffset> offsets = new ArrayList<BlockOffset>();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        offsets.add(new BlockOffset(block, x, y, z));
                    }
                }
            }
            return offsets;
        }

        public static List<BlockOffset> square(class_2248 block, class_2350 dir, int space, class_2248 ... centre) {
            if (centre == null) {
                centre = new class_2248[]{block};
            }
            class_2248 first = centre[0];
            ArrayList<BlockOffset> offsets = new ArrayList<BlockOffset>();
            for (int x = -space; x <= space; ++x) {
                for (int z = -space; z <= space; ++z) {
                    boolean isEdge;
                    boolean bl = isEdge = Math.abs(x) == space || Math.abs(z) == space;
                    if (!isEdge) continue;
                    BlockOffset offset = dir == class_2350.field_11036 || dir == class_2350.field_11033 ? new BlockOffset(x == 0 || z == 0 ? first : block, x, 0, z) : (dir == class_2350.field_11043 || dir == class_2350.field_11035 ? new BlockOffset(x == 0 || z == 0 ? first : block, x, z, 0) : new BlockOffset(x == 0 || z == 0 ? first : block, 0, x, z));
                    offsets.add(offset.allow(centre));
                }
            }
            return offsets;
        }
    }

    public static class AllowedBlocks
    extends HashSet<class_2248> {
        public AllowedBlocks(class_2248 ... blocks) {
            super(List.of(blocks));
        }

        public boolean contains(class_2680 state) {
            return this.contains(state.method_26204());
        }
    }
}

